/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CustomerRpmService {
    @JsonProperty(value="unit")
    private final String unit;
    @JsonProperty(value="package")
    private final String packageName;
    @JsonProperty(value="memory")
    private final Double memoryLimitMib;
    @JsonProperty(value="cpu")
    private final Double cpuLimitCores;

    @JsonCreator
    public CustomerRpmService(@JsonProperty(value="unit") String unit, @JsonProperty(value="package") String packageName, @JsonProperty(value="memory") Double memoryLimitMib, @JsonProperty(value="cpu") Double cpuLimitCores) {
        this.unit = Objects.requireNonNull(unit);
        this.packageName = packageName;
        this.memoryLimitMib = Objects.requireNonNull(memoryLimitMib);
        this.cpuLimitCores = cpuLimitCores == null || cpuLimitCores <= 0.0 ? null : cpuLimitCores;
    }

    public String unitName() {
        return this.unit;
    }

    public String packageName() {
        return this.packageName == null ? this.unitName() : this.packageName;
    }

    public double memoryLimitMib() {
        return this.memoryLimitMib;
    }

    public Optional<Double> cpuLimitCores() {
        return Optional.ofNullable(this.cpuLimitCores);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerRpmService other = (CustomerRpmService)o;
        return this.unit.equals(other.unit) && this.memoryLimitMib.equals(other.memoryLimitMib) && this.packageName().equals(other.packageName()) && this.cpuLimitCores().equals(other.cpuLimitCores());
    }

    public int hashCode() {
        return Objects.hash(this.unitName(), this.packageName(), this.memoryLimitMib(), this.cpuLimitCores());
    }

    public String toString() {
        return "{ unit: %s, package: %s, memory: %s MiB, cpu: %s }".formatted(this.unitName(), this.packageName(), this.memoryLimitMib(), this.cpuLimitCores().map(Object::toString).orElse("unlimited"));
    }
}

