/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.file;

import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.json.FlagData;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FlagDbFile {
    private static final Logger logger = Logger.getLogger(FlagDbFile.class.getName());
    private final Path path;

    public FlagDbFile() {
        this(FileSystems.getDefault());
    }

    public FlagDbFile(FileSystem fileSystem) {
        this(fileSystem.getPath(Defaults.getDefaults().underVespaHome("var/vespa/flag.db"), new String[0]));
    }

    public FlagDbFile(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public Map<FlagId, FlagData> read() {
        Optional<byte[]> bytes = this.readFile();
        if (!bytes.isPresent()) {
            return Map.of();
        }
        return FlagData.deserializeList(bytes.get()).stream().collect(Collectors.toMap(FlagData::id, Function.identity()));
    }

    public boolean sync(Map<FlagId, FlagData> flagData) {
        boolean modified = false;
        Map<FlagId, FlagData> currentFlagData = this.read();
        HashSet<FlagId> flagIdsToBeRemoved = new HashSet<FlagId>(currentFlagData.keySet());
        ArrayList<FlagData> flagDataList = new ArrayList<FlagData>(flagData.values());
        for (FlagData data : flagDataList) {
            flagIdsToBeRemoved.remove(data.id());
            FlagData existingFlagData = currentFlagData.get(data.id());
            if (existingFlagData == null) {
                logger.log(Level.INFO, "New flag " + String.valueOf(data.id()) + ": " + data.serializeToJson());
                modified = true;
                continue;
            }
            if (Objects.equals(data.serializeToJson(), existingFlagData.serializeToJson())) continue;
            logger.log(Level.INFO, "Updating flag " + String.valueOf(data.id()) + " from " + existingFlagData.serializeToJson() + " to " + data.serializeToJson());
            modified = true;
        }
        if (!flagIdsToBeRemoved.isEmpty()) {
            String flagIdsString = flagIdsToBeRemoved.stream().map(FlagId::toString).collect(Collectors.joining(", "));
            logger.log(Level.INFO, "Removing flags " + flagIdsString);
            modified = true;
        }
        if (!modified) {
            return false;
        }
        this.writeFile(FlagData.serializeListToUtf8Json(flagDataList));
        return modified;
    }

    private Optional<byte[]> readFile() {
        try {
            return Optional.of(Files.readAllBytes(this.path));
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeFile(byte[] bytes) {
        Exceptions.uncheck(() -> Files.createDirectories(this.path.getParent(), new FileAttribute[0]));
        Exceptions.uncheck(() -> Files.write(this.path, bytes, new OpenOption[0]));
    }
}

