/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundBooleanFlag MAIN_CHAIN_GRAPH = Flags.defineFeatureFlag("main-chain-graph", true, List.of("hakonhall"), "2022-07-06", "2022-10-05", "Whether to run all tasks in the main task chain up to the one failing to converge (false), or run all tasks in the main task chain whose dependencies have converged (true).  And when suspending, whether to run the tasks in sequence (false) or in reverse sequence (true).", "On first tick of the main chain after (re)start of host admin.", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundDoubleFlag DEFAULT_TERM_WISE_LIMIT = Flags.defineDoubleFlag("default-term-wise-limit", 1.0, List.of("baldersheim"), "2020-12-02", "2023-01-01", "Default limit for when to apply termwise query evaluation", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag QUERY_DISPATCH_POLICY = Flags.defineStringFlag("query-dispatch-policy", "adaptive", List.of("baldersheim"), "2022-08-20", "2023-01-01", "Select query dispatch policy, valid values are adaptive, round-robin, best-of-random-2, latency-amortized-over-requests, latency-amortized-over-time", "Takes effect at redeployment (requires restart)", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag PHRASE_OPTIMIZATION = Flags.defineStringFlag("phrase-optimization", "split", List.of("baldersheim"), "2022-08-28", "2023-01-01", "Select phase optimization, valid values are 'split', 'off'.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag FEED_SEQUENCER_TYPE = Flags.defineStringFlag("feed-sequencer-type", "THROUGHPUT", List.of("baldersheim"), "2020-12-02", "2023-01-01", "Selects type of sequenced executor used for feeding in proton, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment (requires restart)", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag KEEP_STORAGE_NODE_UP = Flags.defineFeatureFlag("keep-storage-node-up", true, List.of("hakonhall"), "2022-07-07", "2022-09-07", "Whether to leave the storage node (with wanted state) UP while the node is permanently down.", "Takes effect immediately for nodes transitioning to permanently down.", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_UNCOMMITTED_MEMORY = Flags.defineIntFlag("max-uncommitted-memory", 130000, List.of("geirst, baldersheim"), "2021-10-21", "2023-01-01", "Max amount of memory holding updates to an attribute before we do a commit.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag RESPONSE_SEQUENCER_TYPE = Flags.defineStringFlag("response-sequencer-type", "ADAPTIVE", List.of("baldersheim"), "2020-12-02", "2023-01-01", "Selects type of sequenced executor used for mbus responses, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag RESPONSE_NUM_THREADS = Flags.defineIntFlag("response-num-threads", 2, List.of("baldersheim"), "2020-12-02", "2023-01-01", "Number of threads used for mbus responses, default is 2, negative number = numcores/4", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_COMMUNICATIONMANAGER_THREAD = Flags.defineFeatureFlag("skip-communicationmanager-thread", false, List.of("baldersheim"), "2020-12-02", "2023-01-01", "Should we skip the communicationmanager thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REQUEST_THREAD = Flags.defineFeatureFlag("skip-mbus-request-thread", false, List.of("baldersheim"), "2020-12-02", "2023-01-01", "Should we skip the mbus request thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REPLY_THREAD = Flags.defineFeatureFlag("skip-mbus-reply-thread", false, List.of("baldersheim"), "2020-12-02", "2023-01-01", "Should we skip the mbus reply thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_THREE_PHASE_UPDATES = Flags.defineFeatureFlag("use-three-phase-updates", true, List.of("vekterli"), "2020-12-02", "2022-10-01", "Whether to enable the use of three-phase updates when bucket replicas are out of sync.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE = Flags.defineFeatureFlag("async-message-handling-on-schedule", false, List.of("baldersheim"), "2020-12-02", "2023-01-01", "Optionally deliver async messages in own thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag FEED_CONCURRENCY = Flags.defineDoubleFlag("feed-concurrency", 0.5, List.of("baldersheim"), "2020-12-02", "2023-01-01", "How much concurrency should be allowed for feed", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag FEED_NICENESS = Flags.defineDoubleFlag("feed-niceness", 0.0, List.of("baldersheim"), "2022-06-24", "2023-01-01", "How nice feeding shall be", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag MBUS_DISPATCH_ON_ENCODE = Flags.defineFeatureFlag("mbus-dispatch-on-encode", true, List.of("baldersheim"), "2022-07-01", "2023-01-01", "Should we use mbus threadpool on encode", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag MBUS_DISPATCH_ON_DECODE = Flags.defineFeatureFlag("mbus-dispatch-on-decode", true, List.of("baldersheim"), "2022-07-01", "2023-01-01", "Should we use mbus threadpool on decode", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MBUS_JAVA_NUM_TARGETS = Flags.defineIntFlag("mbus-java-num-targets", 1, List.of("baldersheim"), "2022-07-05", "2023-01-01", "Number of rpc targets per service", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MBUS_CPP_NUM_TARGETS = Flags.defineIntFlag("mbus-cpp-num-targets", 1, List.of("baldersheim"), "2022-07-05", "2023-01-01", "Number of rpc targets per service", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag RPC_NUM_TARGETS = Flags.defineIntFlag("rpc-num-targets", 1, List.of("baldersheim"), "2022-07-05", "2023-01-01", "Number of rpc targets per content node", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MBUS_JAVA_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("mbus-java-events-before-wakeup", 1, List.of("baldersheim"), "2022-07-05", "2023-01-01", "Number write events before waking up transport thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MBUS_CPP_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("mbus-cpp-events-before-wakeup", 1, List.of("baldersheim"), "2022-07-05", "2023-01-01", "Number write events before waking up transport thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag RPC_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("rpc-events-before-wakeup", 1, List.of("baldersheim"), "2022-07-05", "2023-01-01", "Number write events before waking up transport thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MBUS_NUM_THREADS = Flags.defineIntFlag("mbus-num-threads", 4, List.of("baldersheim"), "2022-07-01", "2023-01-01", "Number of threads used for mbus threadpool", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MBUS_NUM_NETWORK_THREADS = Flags.defineIntFlag("mbus-num-network-threads", 1, List.of("baldersheim"), "2022-07-01", "2023-01-01", "Number of threads used for mbus network", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SHARED_STRING_REPO_NO_RECLAIM = Flags.defineFeatureFlag("shared-string-repo-no-reclaim", false, List.of("baldersheim"), "2022-06-14", "2023-01-01", "Controls whether we do track usage and reclaim unused enum values in shared string repo", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag CONTAINER_DUMP_HEAP_ON_SHUTDOWN_TIMEOUT = Flags.defineFeatureFlag("container-dump-heap-on-shutdown-timeout", false, List.of("baldersheim"), "2021-09-25", "2023-01-01", "Will trigger a heap dump during if container shutdown times out", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag LOAD_CODE_AS_HUGEPAGES = Flags.defineFeatureFlag("load-code-as-hugepages", false, List.of("baldersheim"), "2022-05-13", "2023-01-01", "Will try to map the code segment with huge (2M) pages", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag CONTAINER_SHUTDOWN_TIMEOUT = Flags.defineDoubleFlag("container-shutdown-timeout", 50.0, List.of("baldersheim"), "2021-09-25", "2023-05-01", "Timeout for shutdown of a jdisc container", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundListFlag<String> ALLOWED_ATHENZ_PROXY_IDENTITIES = Flags.defineListFlag("allowed-athenz-proxy-identities", List.of(), String.class, List.of("bjorncs", "tokle"), "2021-02-10", "2022-09-01", "Allowed Athenz proxy identities", "takes effect at redeployment", new FetchVector.Dimension[0]);
    public static final UnboundIntFlag MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS = Flags.defineIntFlag("max-activation-inhibited-out-of-sync-groups", 0, List.of("vekterli"), "2021-02-19", "2022-10-01", "Allows replicas in up to N content groups to not be activated for query visibility if they are out of sync with a majority of other replicas", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_CONCURRENT_MERGES_PER_NODE = Flags.defineIntFlag("max-concurrent-merges-per-node", 16, List.of("balder", "vekterli"), "2021-06-06", "2022-10-01", "Specifies max concurrent merges per content node.", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_MERGE_QUEUE_SIZE = Flags.defineIntFlag("max-merge-queue-size", 100, List.of("balder", "vekterli"), "2021-06-06", "2022-10-01", "Specifies max size of merge queue.", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag MIN_NODE_RATIO_PER_GROUP = Flags.defineDoubleFlag("min-node-ratio-per-group", 0.0, List.of("geirst", "vekterli"), "2021-07-16", "2022-09-01", "Minimum ratio of nodes that have to be available (i.e. not Down) in any hierarchic content cluster group for the group to be Up", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag METRICSPROXY_NUM_THREADS = Flags.defineIntFlag("metricsproxy-num-threads", 2, List.of("balder"), "2021-09-01", "2023-01-01", "Number of threads for metrics proxy", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag AVAILABLE_PROCESSORS = Flags.defineIntFlag("available-processors", 2, List.of("balder"), "2022-01-18", "2023-01-01", "Number of processors the jvm sees in non-application clusters", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLED_HORIZON_DASHBOARD = Flags.defineFeatureFlag("enabled-horizon-dashboard", false, List.of("olaa"), "2021-09-13", "2022-10-01", "Enable Horizon dashboard", "Takes effect immediately", FetchVector.Dimension.TENANT_ID, FetchVector.Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundBooleanFlag UNORDERED_MERGE_CHAINING = Flags.defineFeatureFlag("unordered-merge-chaining", true, List.of("vekterli", "geirst"), "2021-11-15", "2022-09-01", "Enables the use of unordered merge chains for data merge operations", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag IGNORE_THREAD_STACK_SIZES = Flags.defineFeatureFlag("ignore-thread-stack-sizes", false, List.of("arnej"), "2021-11-12", "2022-12-01", "Whether C++ thread creation should ignore any requested stack size", "Triggers restart, takes effect immediately", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_V8_GEO_POSITIONS = Flags.defineFeatureFlag("use-v8-geo-positions", true, List.of("arnej"), "2021-11-15", "2022-12-31", "Use Vespa 8 types and formats for geographical positions", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_COMPACT_BUFFERS = Flags.defineIntFlag("max-compact-buffers", 1, List.of("baldersheim", "geirst", "toregge"), "2021-12-15", "2023-01-01", "Upper limit of buffers to compact in a data store at the same time for each reason (memory usage, address space usage)", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_SERVER_OCSP_STAPLING = Flags.defineFeatureFlag("enable-server-ocsp-stapling", false, List.of("bjorncs"), "2021-12-17", "2022-09-01", "Enable server OCSP stapling for jdisc containers", "Takes effect on redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_DATA_HIGHWAY_IN_AWS = Flags.defineFeatureFlag("enable-data-highway-in-aws", false, List.of("hmusum"), "2022-01-06", "2022-10-01", "Enable Data Highway in AWS", "Takes effect on restart of Docker container", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag MERGE_THROTTLING_POLICY = Flags.defineStringFlag("merge-throttling-policy", "STATIC", List.of("vekterli"), "2022-01-25", "2022-10-01", "Sets the policy used for merge throttling on the content nodes. Valid values: STATIC, DYNAMIC", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag PERSISTENCE_THROTTLING_WS_DECREMENT_FACTOR = Flags.defineDoubleFlag("persistence-throttling-ws-decrement-factor", 1.2, List.of("vekterli"), "2022-01-27", "2022-10-01", "Sets the dynamic throttle policy window size decrement factor for persistence async throttling. Only applies if DYNAMIC policy is used.", "Takes effect on redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag PERSISTENCE_THROTTLING_WS_BACKOFF = Flags.defineDoubleFlag("persistence-throttling-ws-backoff", 0.95, List.of("vekterli"), "2022-01-27", "2022-10-01", "Sets the dynamic throttle policy window size backoff for persistence async throttling. Only applies if DYNAMIC policy is used. Valid range [0, 1]", "Takes effect on redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag PERSISTENCE_THROTTLING_WINDOW_SIZE = Flags.defineIntFlag("persistence-throttling-window-size", -1, List.of("vekterli"), "2022-02-23", "2022-09-01", "If greater than zero, sets both min and max window size to the given number, effectively turning dynamic throttling into a static throttling policy. Only applies if DYNAMIC policy is used.", "Takes effect on redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag PERSISTENCE_THROTTLING_WS_RESIZE_RATE = Flags.defineDoubleFlag("persistence-throttling-ws-resize-rate", 3.0, List.of("vekterli"), "2022-02-23", "2022-09-01", "Sets the dynamic throttle policy resize rate. Only applies if DYNAMIC policy is used.", "Takes effect on redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag PERSISTENCE_THROTTLING_OF_MERGE_FEED_OPS = Flags.defineFeatureFlag("persistence-throttling-of-merge-feed-ops", true, List.of("vekterli"), "2022-02-24", "2022-09-01", "If true, each put/remove contained within a merge is individually throttled as if it were a put/remove from a client. If false, merges are throttled at a persistence thread level, i.e. per ApplyBucketDiff message, regardless of how many document operations are contained within. Only applies if DYNAMIC policy is used.", "Takes effect on redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_QRSERVER_SERVICE_NAME = Flags.defineFeatureFlag("use-qrserver-service-name", false, List.of("arnej"), "2022-01-18", "2022-12-31", "Use backwards-compatible 'qrserver' service name for containers with only 'search' API", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag AVOID_RENAMING_SUMMARY_FEATURES = Flags.defineFeatureFlag("avoid-renaming-summary-features", true, List.of("arnej"), "2022-01-15", "2023-12-31", "Tell backend about the original name of summary-features that were wrapped in a rankingExpression feature", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_BIT_VECTORS = Flags.defineFeatureFlag("enable-bit-vectors", false, List.of("baldersheim"), "2022-05-03", "2022-12-31", "Enables bit vector by default for fast-search attributes", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag APPLICATION_FILES_WITH_UNKNOWN_EXTENSION = Flags.defineStringFlag("fail-deployment-for-files-with-unknown-extension", "FAIL", List.of("hmusum"), "2022-04-27", "2022-10-01", "Whether to log or fail for deployments when app has a file with unknown extension (valid values: LOG, FAIL)", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag NOTIFICATION_DISPATCH_FLAG = Flags.defineFeatureFlag("dispatch-notifications", false, List.of("enygaard"), "2022-05-02", "2022-09-30", "Whether we should send notification for a given tenant", "Takes effect immediately", FetchVector.Dimension.TENANT_ID);
    public static final UnboundBooleanFlag ENABLE_PROXY_PROTOCOL_MIXED_MODE = Flags.defineFeatureFlag("enable-proxy-protocol-mixed-mode", true, List.of("tokle"), "2022-05-09", "2022-09-01", "Enable or disable proxy protocol mixed mode", "Takes effect on redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundListFlag<String> FILE_DISTRIBUTION_ACCEPTED_COMPRESSION_TYPES = Flags.defineListFlag("file-distribution-accepted-compression-types", List.of("gzip", "lz4"), String.class, List.of("hmusum"), "2022-07-05", "2022-10-01", "\u00b4List of accepted compression types used when asking for a file reference. Valid values: gzip, lz4", "Takes effect on restart of service", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundListFlag<String> FILE_DISTRIBUTION_COMPRESSION_TYPES_TO_SERVE = Flags.defineListFlag("file-distribution-compression-types-to-use", List.of("lz4", "gzip"), String.class, List.of("hmusum"), "2022-07-05", "2022-10-01", "List of compression types to use (in preferred order), matched with accepted compression types when serving file references. Valid values: gzip, lz4", "Takes effect on restart of service", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_YUM_PROXY_V2 = Flags.defineFeatureFlag("use-yumproxy-v2", false, List.of("tokle"), "2022-05-05", "2022-09-01", "Use yumproxy-v2", "Takes effect on host admin restart", FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag LOG_FILE_COMPRESSION_ALGORITHM = Flags.defineStringFlag("log-file-compression-algorithm", "", List.of("arnej"), "2022-06-14", "2024-12-31", "Which algorithm to use for compressing log files. Valid values: empty string (default), gzip, zstd", "Takes effect immediately", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SEPARATE_METRIC_CHECK_CONFIG = Flags.defineFeatureFlag("separate-metric-check-config", false, List.of("olaa"), "2022-07-04", "2022-09-01", "Determines whether one metrics config check should be written per Vespa node", "Takes effect on next tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_CAPABILITIES_ENFORCEMENT_MODE = Flags.defineStringFlag("tls-capabilities-enforcement-mode", "disable", List.of("bjorncs", "vekterli"), "2022-07-21", "2024-01-01", "Configure Vespa TLS capability enforcement mode", "Takes effect on restart of Docker container", FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.TENANT_ID, FetchVector.Dimension.VESPA_VERSION);
    public static final UnboundBooleanFlag CLEANUP_TENANT_ROLES = Flags.defineFeatureFlag("cleanup-tenant-roles", false, List.of("olaa"), "2022-08-10", "2022-10-01", "Determines whether old tenant roles should be deleted", "Takes effect next maintenance run", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag USE_TWO_PHASE_DOCUMENT_GC = Flags.defineFeatureFlag("use-two-phase-document-gc", false, List.of("vekterli"), "2022-08-24", "2022-11-01", "Use two-phase document GC in content clusters", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.defineStringFlag(flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, (String value) -> true, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Predicate<String> validator, FetchVector.Dimension ... dimensions) {
        return Flags.define((i, d, v) -> new UnboundStringFlag(i, (String)d, v, validator), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(FetchVector.Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, owners, Flags.parseDate(createdAt), Flags.parseDate(expiresAt), description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    private static Instant parseDate(String rawDate) {
        return DateTimeFormatter.ISO_DATE.parse((CharSequence)rawDate, LocalDate::from).atStartOfDay().toInstant(ZoneOffset.UTC);
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting(FlagId ... flagsToKeep) {
        return new Replacer(flagsToKeep);
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer(FlagId ... flagsToKeep) {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
            List.of(flagsToKeep).forEach(id -> flags.put((FlagId)id, this.savedFlags.get(id)));
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }
}

