/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostResources {
    private static final Set<String> validDiskSpeeds = Set.of("slow", "fast");
    private static final Set<String> validStorageTypes = Set.of("remote", "local");
    private static final Set<String> validClusterTypes = Set.of("container", "content", "combined", "admin");
    private static final Set<String> validArchitectures = Set.of("arm64", "x86_64");
    private final double vcpu;
    private final double memoryGb;
    private final double diskGb;
    private final double bandwidthGbps;
    private final String diskSpeed;
    private final String storageType;
    private final Optional<String> clusterType;
    private final int containers;
    private final String architecture;

    @JsonCreator
    public HostResources(@JsonProperty(value="vcpu") Double vcpu, @JsonProperty(value="memoryGb") Double memoryGb, @JsonProperty(value="diskGb") Double diskGb, @JsonProperty(value="bandwidthGbps") Double bandwidthGbps, @JsonProperty(value="diskSpeed") String diskSpeed, @JsonProperty(value="storageType") String storageType, @JsonProperty(value="clusterType") String clusterType, @JsonProperty(value="containers") Integer containers, @JsonProperty(value="architecture") String architecture) {
        this.vcpu = HostResources.requirePositive("vcpu", vcpu);
        this.memoryGb = HostResources.requirePositive("memoryGb", memoryGb);
        this.diskGb = HostResources.requirePositive("diskGb", diskGb);
        this.bandwidthGbps = HostResources.requirePositive("bandwidthGbps", bandwidthGbps);
        this.diskSpeed = HostResources.validateEnum("diskSpeed", validDiskSpeeds, diskSpeed);
        this.storageType = HostResources.validateEnum("storageType", validStorageTypes, storageType);
        this.clusterType = Optional.ofNullable(clusterType).map(cType -> HostResources.validateEnum("clusterType", validClusterTypes, cType));
        this.containers = HostResources.requirePositive("containers", containers);
        this.architecture = HostResources.validateEnum("architecture", validArchitectures, architecture);
    }

    @JsonProperty(value="vcpu")
    public double vcpu() {
        return this.vcpu;
    }

    @JsonProperty(value="memoryGb")
    public double memoryGb() {
        return this.memoryGb;
    }

    @JsonProperty(value="diskGb")
    public double diskGb() {
        return this.diskGb;
    }

    @JsonProperty(value="bandwidthGbps")
    public double bandwidthGbps() {
        return this.bandwidthGbps;
    }

    @JsonProperty(value="diskSpeed")
    public String diskSpeed() {
        return this.diskSpeed;
    }

    @JsonProperty(value="storageType")
    public String storageType() {
        return this.storageType;
    }

    @JsonProperty(value="clusterType")
    public String clusterTypeOrNull() {
        return this.clusterType.orElse(null);
    }

    @JsonIgnore
    public Optional<String> clusterType() {
        return this.clusterType;
    }

    @JsonProperty(value="containers")
    public int containers() {
        return this.containers;
    }

    @JsonProperty(value="architecture")
    public String architecture() {
        return this.architecture;
    }

    public boolean satisfiesClusterType(String clusterType) {
        return this.clusterType.map(clusterType::equalsIgnoreCase).orElse(true);
    }

    private static double requirePositive(String name, Double value) {
        HostResources.requireNonNull(name, value);
        if (value <= 0.0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    private static int requirePositive(String name, Integer value) {
        HostResources.requireNonNull(name, value);
        if (value <= 0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    private static String validateEnum(String name, Set<String> validValues, String value) {
        HostResources.requireNonNull(name, value);
        if (!validValues.contains(value)) {
            throw new IllegalArgumentException("Invalid " + name + ", valid values are: " + validValues + ", got: " + value);
        }
        return value;
    }

    private static <T> T requireNonNull(String name, T value) {
        return Objects.requireNonNull(value, () -> "'" + name + "' has not been specified");
    }

    public String toString() {
        return "HostResources{vcpu=" + this.vcpu + ", memoryGb=" + this.memoryGb + ", diskGb=" + this.diskGb + ", bandwidthGbps=" + this.bandwidthGbps + ", diskSpeed='" + this.diskSpeed + "', storageType='" + this.storageType + "', clusterType='" + this.clusterType + "', containers=" + this.containers + ", architecture=" + this.architecture + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostResources resources = (HostResources)o;
        return Double.compare(resources.vcpu, this.vcpu) == 0 && Double.compare(resources.memoryGb, this.memoryGb) == 0 && Double.compare(resources.diskGb, this.diskGb) == 0 && Double.compare(resources.bandwidthGbps, this.bandwidthGbps) == 0 && this.diskSpeed.equals(resources.diskSpeed) && this.storageType.equals(resources.storageType) && this.clusterType.equals(resources.clusterType) && this.containers == resources.containers && this.architecture.equals(resources.architecture);
    }

    public int hashCode() {
        return Objects.hash(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.clusterType, this.containers, this.architecture);
    }
}

