/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSerializer;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.UnboundFlagImpl;

public abstract class FlagImpl<T, F extends FlagImpl<T, F>>
implements Flag<T, F> {
    private final FlagId id;
    private final T defaultValue;
    private final FlagSerializer<T> serializer;
    private final FetchVector fetchVector;
    private final UnboundFlagImpl.FlagFactory<T, F> factory;
    private final FlagSource source;

    protected FlagImpl(FlagId id, T defaultValue, FetchVector fetchVector, FlagSerializer<T> serializer, FlagSource source, UnboundFlagImpl.FlagFactory<T, F> factory) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.serializer = serializer;
        this.fetchVector = fetchVector;
        this.factory = factory;
        this.source = source;
    }

    @Override
    public FlagId id() {
        return this.id;
    }

    @Override
    public F with(Dimension dimension, String dimensionValue) {
        return (F)((FlagImpl)this.factory.create(this.id, this.defaultValue, this.fetchVector.with(dimension, dimensionValue), this.serializer, this.source));
    }

    @Override
    public T boxedValue() {
        return (T)this.source.fetch(this.id, this.fetchVector).map(this.serializer::deserialize).orElse(this.defaultValue);
    }

    @Override
    public FlagSerializer<T> serializer() {
        return this.serializer;
    }
}

