/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class FetchVector {
    private final Map<Dimension, String> map;

    public FetchVector() {
        this.map = Map.of();
    }

    public static FetchVector fromMap(Map<Dimension, String> map) {
        return new FetchVector(map);
    }

    private FetchVector(Map<Dimension, String> map) {
        this.map = Map.copyOf(map);
    }

    public Optional<String> getValue(Dimension dimension) {
        return Optional.ofNullable(this.map.get((Object)dimension));
    }

    public Map<Dimension, String> toMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean hasDimension(Dimension dimension) {
        return this.map.containsKey((Object)dimension);
    }

    public Set<Dimension> dimensions() {
        return this.map.keySet();
    }

    public FetchVector with(Dimension dimension, String value) {
        if (value == null) {
            return this.makeFetchVector(merged -> merged.remove((Object)dimension));
        }
        return this.makeFetchVector(merged -> merged.put(dimension, value));
    }

    public FetchVector with(FetchVector override) {
        return this.makeFetchVector(vector -> vector.putAll(override.map));
    }

    private FetchVector makeFetchVector(Consumer<Map<Dimension, String>> mapModifier) {
        EnumMap<Dimension, String> mergedMap = new EnumMap<Dimension, String>(Dimension.class);
        mergedMap.putAll(this.map);
        mapModifier.accept(mergedMap);
        return new FetchVector(mergedMap);
    }

    public FetchVector without(Dimension dimension) {
        return this.makeFetchVector(merged -> merged.remove((Object)dimension));
    }

    public FetchVector without(Collection<Dimension> dimensions) {
        return this.makeFetchVector(merged -> merged.keySet().removeAll(dimensions));
    }

    public String toString() {
        return "FetchVector{map=" + this.map + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchVector that = (FetchVector)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static enum Dimension {
        APPLICATION_ID,
        CLOUD,
        CLUSTER_ID,
        CLUSTER_TYPE,
        CONSOLE_USER_EMAIL,
        ENVIRONMENT,
        HOSTNAME,
        NODE_TYPE,
        SYSTEM,
        TENANT_ID,
        VESPA_VERSION,
        ZONE_ID;

    }
}

