/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundDoubleFlag DEFAULT_TERM_WISE_LIMIT = Flags.defineDoubleFlag("default-term-wise-limit", 1.0, List.of("baldersheim"), "2020-12-02", "2022-02-01", "Default limit for when to apply termwise query evaluation", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag FEED_SEQUENCER_TYPE = Flags.defineStringFlag("feed-sequencer-type", "THROUGHPUT", List.of("baldersheim"), "2020-12-02", "2022-02-01", "Selects type of sequenced executor used for feeding in proton, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment (requires restart)", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag FEED_TASK_LIMIT = Flags.defineIntFlag("feed-task-limit", 1000, List.of("geirst, baldersheim"), "2021-10-14", "2022-02-01", "The task limit used by the executors handling feed in proton", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag FEED_MASTER_TASK_LIMIT = Flags.defineIntFlag("feed-master-task-limit", 1000, List.of("geirst, baldersheim"), "2021-11-18", "2022-02-01", "The task limit used by the master thread in each document db in proton. Ignored when set to 0.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag SHARED_FIELD_WRITER_EXECUTOR = Flags.defineStringFlag("shared-field-writer-executor", "NONE", List.of("geirst, baldersheim"), "2021-11-05", "2022-02-01", "Whether to use a shared field writer executor for the document database(s) in proton. Valid values: NONE, INDEX, INDEX_AND_ATTRIBUTE, DOCUMENT_DB", "Takes effect at redeployment (requires restart)", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_UNCOMMITTED_MEMORY = Flags.defineIntFlag("max-uncommitted-memory", 130000, List.of("geirst, baldersheim"), "2021-10-21", "2022-02-01", "Max amount of memory holding updates to an attribute before we do a commit.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag RESPONSE_SEQUENCER_TYPE = Flags.defineStringFlag("response-sequencer-type", "ADAPTIVE", List.of("baldersheim"), "2020-12-02", "2022-02-01", "Selects type of sequenced executor used for mbus responses, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag RESPONSE_NUM_THREADS = Flags.defineIntFlag("response-num-threads", 2, List.of("baldersheim"), "2020-12-02", "2022-02-01", "Number of threads used for mbus responses, default is 2, negative number = numcores/4", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_COMMUNICATIONMANAGER_THREAD = Flags.defineFeatureFlag("skip-communicationmanager-thread", false, List.of("baldersheim"), "2020-12-02", "2022-02-01", "Should we skip the communicationmanager thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REQUEST_THREAD = Flags.defineFeatureFlag("skip-mbus-request-thread", false, List.of("baldersheim"), "2020-12-02", "2022-02-01", "Should we skip the mbus request thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REPLY_THREAD = Flags.defineFeatureFlag("skip-mbus-reply-thread", false, List.of("baldersheim"), "2020-12-02", "2022-02-01", "Should we skip the mbus reply thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_THREE_PHASE_UPDATES = Flags.defineFeatureFlag("use-three-phase-updates", false, List.of("vekterli"), "2020-12-02", "2022-02-01", "Whether to enable the use of three-phase updates when bucket replicas are out of sync.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag HIDE_SHARED_ROUTING_ENDPOINT = Flags.defineFeatureFlag("hide-shared-routing-endpoint", false, List.of("tokle", "bjormel"), "2020-12-02", "2022-02-01", "Whether the controller should hide shared routing layer endpoint", "Takes effect immediately", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE = Flags.defineFeatureFlag("async-message-handling-on-schedule", false, List.of("baldersheim"), "2020-12-02", "2022-02-01", "Optionally deliver async messages in own thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag FEED_CONCURRENCY = Flags.defineDoubleFlag("feed-concurrency", 0.5, List.of("baldersheim"), "2020-12-02", "2022-02-01", "How much concurrency should be allowed for feed", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_FEED_BLOCK_IN_DISTRIBUTOR = Flags.defineFeatureFlag("enable-feed-block-in-distributor", true, List.of("geirst"), "2021-01-27", "2022-01-31", "Enables blocking of feed in the distributor if resource usage is above limit on at least one content node", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag CONTAINER_DUMP_HEAP_ON_SHUTDOWN_TIMEOUT = Flags.defineFeatureFlag("container-dump-heap-on-shutdown-timeout", false, List.of("baldersheim"), "2021-09-25", "2022-02-01", "Will trigger a heap dump during if container shutdown times out", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag CONTAINER_SHUTDOWN_TIMEOUT = Flags.defineDoubleFlag("container-shutdown-timeout", 50.0, List.of("baldersheim"), "2021-09-25", "2022-02-01", "Timeout for shutdown of a jdisc container", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundListFlag<String> ALLOWED_ATHENZ_PROXY_IDENTITIES = Flags.defineListFlag("allowed-athenz-proxy-identities", List.of(), String.class, List.of("bjorncs", "tokle"), "2021-02-10", "2022-02-01", "Allowed Athenz proxy identities", "takes effect at redeployment", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag GENERATE_NON_MTLS_ENDPOINT = Flags.defineFeatureFlag("generate-non-mtls-endpoint", true, List.of("tokle"), "2021-02-18", "2022-02-01", "Whether to generate the non-mtls endpoint", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS = Flags.defineIntFlag("max-activation-inhibited-out-of-sync-groups", 0, List.of("vekterli"), "2021-02-19", "2022-02-01", "Allows replicas in up to N content groups to not be activated for query visibility if they are out of sync with a majority of other replicas", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_CONCURRENT_MERGES_PER_NODE = Flags.defineIntFlag("max-concurrent-merges-per-node", 16, List.of("balder", "vekterli"), "2021-06-06", "2022-02-01", "Specifies max concurrent merges per content node.", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_MERGE_QUEUE_SIZE = Flags.defineIntFlag("max-merge-queue-size", 100, List.of("balder", "vekterli"), "2021-06-06", "2022-02-01", "Specifies max size of merge queue.", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag IGNORE_MERGE_QUEUE_LIMIT = Flags.defineFeatureFlag("ignore-merge-queue-limit", true, List.of("vekterli", "geirst"), "2021-10-06", "2022-03-01", "Specifies if merges that are forwarded (chained) from another content node are always allowed to be enqueued even if the queue is otherwise full.", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag MIN_NODE_RATIO_PER_GROUP = Flags.defineDoubleFlag("min-node-ratio-per-group", 0.0, List.of("geirst", "vekterli"), "2021-07-16", "2022-03-01", "Minimum ratio of nodes that have to be available (i.e. not Down) in any hierarchic content cluster group for the group to be Up", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag METRICSPROXY_NUM_THREADS = Flags.defineIntFlag("metricsproxy-num-threads", 2, List.of("balder"), "2021-09-01", "2022-02-01", "Number of threads for metrics proxy", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLED_HORIZON_DASHBOARD = Flags.defineFeatureFlag("enabled-horizon-dashboard", false, List.of("olaa"), "2021-09-13", "2022-02-01", "Enable Horizon dashboard", "Takes effect immediately", FetchVector.Dimension.TENANT_ID, FetchVector.Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundBooleanFlag ENABLE_ONPREM_TENANT_S3_ARCHIVE = Flags.defineFeatureFlag("enable-onprem-tenant-s3-archive", false, List.of("bjorncs"), "2021-09-14", "2022-02-01", "Enable tenant S3 buckets in cd/main. Must be set on controller cluster only.", "Takes effect immediately", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.TENANT_ID);
    public static final UnboundBooleanFlag DELETE_UNMAINTAINED_CERTIFICATES = Flags.defineFeatureFlag("delete-unmaintained-certificates", false, List.of("andreer"), "2021-09-23", "2022-02-14", "Whether to delete certificates that are known by provider but not by controller", "Takes effect on next run of EndpointCertificateMaintainer", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag ENABLE_TENANT_DEVELOPER_ROLE = Flags.defineFeatureFlag("enable-tenant-developer-role", false, List.of("bjorncs"), "2021-09-23", "2022-02-01", "Enable tenant developer Athenz role in cd/main. Must be set on controller cluster only.", "Takes effect immediately", FetchVector.Dimension.TENANT_ID);
    public static final UnboundBooleanFlag ENABLE_ROUTING_REUSE_PORT = Flags.defineFeatureFlag("enable-routing-reuse-port", true, List.of("mortent"), "2021-09-29", "2022-02-01", "Enable reuse port in routing configuration", "Takes effect on container restart", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_TENANT_OPERATOR_ROLE = Flags.defineFeatureFlag("enable-tenant-operator-role", false, List.of("bjorncs"), "2021-09-29", "2022-02-01", "Enable tenant specific operator roles in public systems. For controllers only.", "Takes effect on subsequent maintainer invocation", FetchVector.Dimension.TENANT_ID);
    public static final UnboundIntFlag DISTRIBUTOR_MERGE_BUSY_WAIT = Flags.defineIntFlag("distributor-merge-busy-wait", 1, List.of("geirst", "vekterli"), "2021-10-04", "2022-03-01", "Number of seconds that scheduling of new merge operations in the distributor should be inhibited towards a content node that has indicated merge busy", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag DISTRIBUTOR_ENHANCED_MAINTENANCE_SCHEDULING = Flags.defineFeatureFlag("distributor-enhanced-maintenance-scheduling", true, List.of("vekterli", "geirst"), "2021-10-14", "2022-01-31", "Enable enhanced maintenance operation scheduling semantics on the distributor", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ASYNC_APPLY_BUCKET_DIFF = Flags.defineFeatureFlag("async-apply-bucket-diff", true, List.of("geirst", "vekterli"), "2021-10-22", "2022-01-31", "Whether portions of apply bucket diff handling will be performed asynchronously", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag UNORDERED_MERGE_CHAINING = Flags.defineFeatureFlag("unordered-merge-chaining", true, List.of("vekterli", "geirst"), "2021-11-15", "2022-03-01", "Enables the use of unordered merge chains for data merge operations", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag JDK_VERSION = Flags.defineStringFlag("jdk-version", "11", List.of("hmusum"), "2021-10-25", "2022-03-01", "JDK version to use on host and inside containers. Note application-id dimension only applies for container, while hostname and node type applies for host.", "Takes effect on restart for Docker container and on next host-admin tick for host", FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.TENANT_ID, FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.NODE_TYPE);
    public static final UnboundBooleanFlag IGNORE_THREAD_STACK_SIZES = Flags.defineFeatureFlag("ignore-thread-stack-sizes", false, List.of("arnej"), "2021-11-12", "2022-01-31", "Whether C++ thread creation should ignore any requested stack size", "Triggers restart, takes effect immediately", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_V8_GEO_POSITIONS = Flags.defineFeatureFlag("use-v8-geo-positions", false, List.of("arnej"), "2021-11-15", "2022-12-31", "Use Vespa 8 types and formats for geographical positions", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_LEGACY_LB_SERVICES = Flags.defineFeatureFlag("use-legacy-lb-services", false, List.of("tokle"), "2021-11-22", "2022-02-01", "Whether to generate routing table based on legacy lb-services config", "Takes effect on container reboot", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_V8_DOC_MANAGER_CFG = Flags.defineFeatureFlag("use-v8-doc-manager-cfg", false, List.of("arnej", "baldersheim"), "2021-12-09", "2022-12-31", "Use new (preparing for Vespa 8) section in documentmanager.def", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_COMPACT_BUFFERS = Flags.defineIntFlag("max-compact-buffers", 1, List.of("baldersheim", "geirst", "toregge"), "2021-12-15", "2022-03-31", "Upper limit of buffers to compact in a data store at the same time for each reason (memory usage, address space usage)", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag FAIL_DEPLOYMENT_WITH_INVALID_JVM_OPTIONS = Flags.defineFeatureFlag("fail-deployment-with-invalid-jvm-options", false, List.of("hmusum"), "2021-12-20", "2022-02-20", "Whether to fail deployments with invalid JVM options in services.xml", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_SERVER_OCSP_STAPLING = Flags.defineFeatureFlag("enable-server-ocsp-stapling", false, List.of("bjorncs"), "2021-12-17", "2022-06-01", "Enable server OCSP stapling for jdisc containers", "Takes effect on redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_DATA_HIGHWAY_IN_AWS = Flags.defineFeatureFlag("enable-data-highway-in-aws", false, List.of("hmusum"), "2022-01-06", "2022-04-06", "Enable Data Highway in AWS", "Takes effect on restart of Docker container", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag ZOOKEEPER_SNAPSHOT_METHOD = Flags.defineStringFlag("zookeeper-snapshot-method", "", List.of("hmusum"), "2022-01-11", "2022-02-11", "ZooKeeper snapshot method. Valid values are '', 'gz' and 'snappy'", "Takes effect on Docker container restart", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.NODE_TYPE);
    public static final UnboundStringFlag PERSISTENCE_ASYNC_THROTTLING = Flags.defineStringFlag("persistence-async-throttling", "UNLIMITED", List.of("vekterli"), "2022-01-12", "2022-05-01", "Sets the throttling policy used for async persistence operations on the content nodes. Valid values: UNLIMITED, DYNAMIC", "Triggers restart, takes effect immediately", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundStringFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(FetchVector.Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, owners, Flags.parseDate(createdAt), Flags.parseDate(expiresAt), description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    private static Instant parseDate(String rawDate) {
        return DateTimeFormatter.ISO_DATE.parse((CharSequence)rawDate, LocalDate::from).atStartOfDay().toInstant(ZoneOffset.UTC);
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting(FlagId ... flagsToKeep) {
        return new Replacer(flagsToKeep);
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer(FlagId ... flagsToKeep) {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
            List.of(flagsToKeep).forEach(id -> flags.put((FlagId)id, this.savedFlags.get(id)));
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }
}

