/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.JsonNodeRawFlag;
import com.yahoo.vespa.flags.RawFlag;
import com.yahoo.vespa.flags.json.Condition;
import com.yahoo.vespa.flags.json.wire.WireRule;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Rule {
    private final List<Condition> andConditions;
    private final Optional<RawFlag> valueToApply;

    public Rule(Optional<RawFlag> valueToApply, Condition ... andConditions) {
        this(valueToApply, List.of(andConditions));
    }

    public Rule(Optional<RawFlag> valueToApply, List<Condition> andConditions) {
        this.andConditions = List.copyOf(andConditions);
        this.valueToApply = valueToApply;
    }

    public List<Condition> conditions() {
        return this.andConditions;
    }

    public boolean match(FetchVector fetchVector) {
        return this.andConditions.stream().allMatch(condition -> condition.test(fetchVector));
    }

    public boolean partialMatch(FetchVector fetchVector) {
        return this.andConditions.stream().allMatch(condition -> !fetchVector.hasDimension(condition.dimension()) || condition.test(fetchVector));
    }

    public Optional<RawFlag> getValueToApply() {
        return this.valueToApply;
    }

    public WireRule toWire() {
        WireRule wireRule = new WireRule();
        if (!this.andConditions.isEmpty()) {
            wireRule.andConditions = this.andConditions.stream().map(Condition::toWire).collect(Collectors.toList());
        }
        wireRule.value = this.valueToApply.map(RawFlag::asJsonNode).orElse(null);
        return wireRule;
    }

    public static Rule fromWire(WireRule wireRule) {
        List<Condition> conditions = wireRule.andConditions == null ? Collections.emptyList() : wireRule.andConditions.stream().map(Condition::fromWire).collect(Collectors.toList());
        Optional<RawFlag> value = wireRule.value == null ? Optional.empty() : Optional.of(JsonNodeRawFlag.fromJsonNode(wireRule.value));
        return new Rule(value, conditions);
    }
}

