/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.json.Condition;
import com.yahoo.vespa.flags.json.DimensionHelper;
import com.yahoo.vespa.flags.json.wire.WireCondition;
import java.util.List;

public abstract class ListCondition
implements Condition {
    private final Condition.Type type;
    private final FetchVector.Dimension dimension;
    private final List<String> values;
    private final boolean isWhitelist;

    protected ListCondition(Condition.Type type, Condition.CreateParams params) {
        this.type = type;
        this.dimension = params.dimension();
        this.values = List.copyOf(params.values());
        boolean bl = this.isWhitelist = type == Condition.Type.WHITELIST;
        if (params.predicate().isPresent()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not support the 'predicate' field");
        }
    }

    @Override
    public Condition.Type type() {
        return this.type;
    }

    @Override
    public FetchVector.Dimension dimension() {
        return this.dimension;
    }

    @Override
    public Condition.CreateParams toCreateParams() {
        return new Condition.CreateParams(this.dimension).withValues(this.values);
    }

    @Override
    public boolean test(FetchVector fetchVector) {
        boolean listContainsValue = fetchVector.getValue(this.dimension).map(this.values::contains).orElse(false);
        return this.isWhitelist == listContainsValue;
    }

    @Override
    public WireCondition toWire() {
        WireCondition condition = new WireCondition();
        condition.type = this.type.toWire();
        condition.dimension = DimensionHelper.toWire(this.dimension);
        condition.values = this.values.isEmpty() ? null : this.values;
        return condition;
    }
}

