/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class PermanentFlags {
    static final List<String> OWNERS = List.of();
    static final Instant CREATED_AT = Instant.EPOCH;
    static final Instant EXPIRES_AT = Instant.MAX;

    private PermanentFlags() {
    }

    private static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.defineFeatureFlag(flagId, defaultValue, OWNERS, PermanentFlags.toString(CREATED_AT), PermanentFlags.toString(EXPIRES_AT), description, modificationEffect, dimensions);
    }

    private static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.defineStringFlag(flagId, defaultValue, OWNERS, PermanentFlags.toString(CREATED_AT), PermanentFlags.toString(EXPIRES_AT), description, modificationEffect, dimensions);
    }

    private static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.defineIntFlag(flagId, defaultValue, OWNERS, PermanentFlags.toString(CREATED_AT), PermanentFlags.toString(EXPIRES_AT), description, modificationEffect, dimensions);
    }

    private static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.defineLongFlag(flagId, defaultValue, OWNERS, PermanentFlags.toString(CREATED_AT), PermanentFlags.toString(EXPIRES_AT), description, modificationEffect, dimensions);
    }

    private static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.defineDoubleFlag(flagId, defaultValue, OWNERS, PermanentFlags.toString(CREATED_AT), PermanentFlags.toString(EXPIRES_AT), description, modificationEffect, dimensions);
    }

    private static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.defineJacksonFlag(flagId, defaultValue, jacksonClass, OWNERS, PermanentFlags.toString(CREATED_AT), PermanentFlags.toString(EXPIRES_AT), description, modificationEffect, dimensions);
    }

    private static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.defineListFlag(flagId, defaultValue, elementClass, OWNERS, PermanentFlags.toString(CREATED_AT), PermanentFlags.toString(EXPIRES_AT), description, modificationEffect, dimensions);
    }

    private static String toString(Instant instant) {
        return DateTimeFormatter.ISO_DATE.format(instant);
    }
}

