/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import com.yahoo.vespa.flags.custom.ClusterCapacity;
import com.yahoo.vespa.flags.custom.SharedHost;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundBooleanFlag FLEET_CANARY = Flags.defineFeatureFlag("fleet-canary", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether the host is a fleet canary.", "Takes effect on next host admin tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundListFlag<String> DISABLED_HOST_ADMIN_TASKS = Flags.defineListFlag("disabled-host-admin-tasks", List.of(), String.class, List.of("nobody"), "2020-12-02", "2021-02-01", "List of host-admin task names (as they appear in the log, e.g. root>main>UpgradeTask), or some node-agent functionality (see NodeAgentTask), that should be skipped", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.NODE_TYPE);
    public static final UnboundStringFlag DOCKER_VERSION = Flags.defineStringFlag("docker-version", "1.13.1-102.git7f2769b", List.of("nobody"), "2020-12-02", "2021-02-01", "The version of the docker to use of the format VERSION-REL: The YUM package to be installed will be 2:docker-VERSION-REL.el7.centos.x86_64 in AWS (and without '.centos' otherwise). If docker-version is not of this format, it must be parseable by YumPackageName::fromString.", "Takes effect on next tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundDoubleFlag CONTAINER_CPU_CAP = Flags.defineDoubleFlag("container-cpu-cap", 0.0, List.of("nobody"), "2020-12-02", "2021-02-01", "Hard limit on how many CPUs a container may use. This value is multiplied by CPU allocated to node, so to cap CPU at 200%, set this to 2, etc.", "Takes effect on next node agent tick. Change is orchestrated, but does NOT require container restart", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag REBOOT_INTERVAL_IN_DAYS = Flags.defineIntFlag("reboot-interval-in-days", 30, List.of("nobody"), "2020-12-02", "2021-02-01", "No reboots are scheduled 0x-1x reboot intervals after the previous reboot, while reboot is scheduled evenly distributed in the 1x-2x range (and naturally guaranteed at the 2x boundary).", "Takes effect on next run of NodeRebooter", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag RETIRE_WITH_PERMANENTLY_DOWN = Flags.defineFeatureFlag("retire-with-permanently-down", false, List.of("nobody"), "2020-12-02", "2021-02-01", "If enabled, retirement will end with setting the host status to PERMANENTLY_DOWN, instead of ALLOWED_TO_BE_DOWN (old behavior).", "Takes effect on the next run of RetiredExpirer.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundListFlag<ClusterCapacity> PREPROVISION_CAPACITY = Flags.defineListFlag("preprovision-capacity", List.of(), ClusterCapacity.class, List.of("nobody"), "2020-12-02", "2021-02-01", "Specifies the resources that ought to be immediately available for additional cluster allocations.  If the resources are not available, additional hosts will be provisioned. Only applies to dynamically provisioned zones.", "Takes effect on next iteration of DynamicProvisioningMaintainer.", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag COMPACT_PREPROVISION_CAPACITY = Flags.defineFeatureFlag("compact-preprovision-capacity", true, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether preprovision capacity can be satisfied with available capacity on hosts with existing allocations.  Historically preprovision-capacity referred to empty hosts.", "Takes effect on next iteration of DynamicProvisioningMaintainer.", new FetchVector.Dimension[0]);
    public static final UnboundJacksonFlag<SharedHost> SHARED_HOST = Flags.defineJacksonFlag("shared-host", SharedHost.createDisabled(), SharedHost.class, List.of("nobody"), "2020-12-02", "2021-02-01", "Specifies whether shared hosts can be provisioned, and if so, the advertised node resources of the host, the maximum number of containers, etc.", "Takes effect on next iteration of DynamicProvisioningMaintainer.", new FetchVector.Dimension[0]);
    public static final UnboundListFlag<String> INACTIVE_MAINTENANCE_JOBS = Flags.defineListFlag("inactive-maintenance-jobs", List.of(), String.class, List.of("nobody"), "2020-12-02", "2021-02-01", "The list of maintenance jobs that are inactive.", "Takes effect immediately, but any currently running jobs will run until completion.", new FetchVector.Dimension[0]);
    public static final UnboundDoubleFlag DEFAULT_TERM_WISE_LIMIT = Flags.defineDoubleFlag("default-term-wise-limit", 1.0, List.of("nobody"), "2020-12-02", "2021-02-01", "Default limit for when to apply termwise query evaluation", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag JVM_GC_OPTIONS = Flags.defineStringFlag("jvm-gc-options", "", List.of("nobody"), "2020-12-02", "2021-02-01", "Sets deafult jvm gc options", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag FEED_SEQUENCER_TYPE = Flags.defineStringFlag("feed-sequencer-type", "LATENCY", List.of("nobody"), "2020-12-02", "2021-02-01", "Selects type of sequenced executor used for feeding, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag RESPONSE_SEQUENCER_TYPE = Flags.defineStringFlag("response-sequencer-type", "ADAPTIVE", List.of("nobody"), "2020-12-02", "2021-02-01", "Selects type of sequenced executor used for mbus responses, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag RESPONSE_NUM_THREADS = Flags.defineIntFlag("response-num-threads", 2, List.of("nobody"), "2020-12-02", "2021-02-01", "Number of threads used for mbus responses, default is 2, negative number = numcores/4", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_COMMUNICATIONMANAGER_THREAD = Flags.defineFeatureFlag("skip-communicatiomanager-thread", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Should we skip the communicationmanager thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REQUEST_THREAD = Flags.defineFeatureFlag("skip-mbus-request-thread", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Should we skip the mbus request thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REPLY_THREAD = Flags.defineFeatureFlag("skip-mbus-reply-thread", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Should we skip the mbus reply thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_THREE_PHASE_UPDATES = Flags.defineFeatureFlag("use-three-phase-updates", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to enable the use of three-phase updates when bucket replicas are out of sync.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_DIRECT_STORAGE_API_RPC = Flags.defineFeatureFlag("use-direct-storage-api-rpc", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to use direct RPC for Storage API communication between content cluster nodes.", "Takes effect at restart of distributor and content node process", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_FAST_VALUE_TENSOR_IMPLEMENTATION = Flags.defineFeatureFlag("use-fast-value-tensor-implementation", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to use FastValueBuilderFactory as the tensor implementation on all content nodes.", "Takes effect at restart of content node process", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag HOST_HARDENING = Flags.defineFeatureFlag("host-hardening", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to enable host hardening Linux baseline.", "Takes effect on next tick or on host-admin restart (may vary where used).", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag TCP_ABORT_ON_OVERFLOW = Flags.defineFeatureFlag("tcp-abort-on-overflow", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to set /proc/sys/net/ipv4/tcp_abort_on_overflow to 0 (false) or 1 (true)", "Takes effect on next host-admin tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag ZOOKEEPER_SERVER_VERSION = Flags.defineStringFlag("zookeeper-server-version", "3.5.6", List.of("nobody"), "2020-12-02", "2021-02-01", "ZooKeeper server version, a jar file zookeeper-server-<ZOOKEEPER_SERVER_VERSION>-jar-with-dependencies.jar must exist", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_FOR_ZOOKEEPER_CLIENT_SERVER_COMMUNICATION = Flags.defineStringFlag("tls-for-zookeeper-client-server-communication", "OFF", List.of("nobody"), "2020-12-02", "2021-02-01", "How to setup TLS for ZooKeeper client/server communication. Valid values are OFF, PORT_UNIFICATION, TLS_WITH_PORT_UNIFICATION, TLS_ONLY", "Takes effect on restart of config server", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_TLS_FOR_ZOOKEEPER_CLIENT = Flags.defineFeatureFlag("use-tls-for-zookeeper-client", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to use TLS for ZooKeeper clients", "Takes effect on restart of process", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag VALIDATE_ENDPOINT_CERTIFICATES = Flags.defineFeatureFlag("validate-endpoint-certificates", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether endpoint certificates should be validated before use", "Takes effect on the next deployment of the application", new FetchVector.Dimension[0]);
    public static final UnboundStringFlag DELETE_UNUSED_ENDPOINT_CERTIFICATES = Flags.defineStringFlag("delete-unused-endpoint-certificates", "disable", List.of("nobody"), "2020-12-02", "2021-02-01", "Whether the endpoint certificate maintainer should delete unused certificates in cameo/zk", "Takes effect on next scheduled run of maintainer - set to \"disable\", \"dryrun\" or \"enable\"", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag USE_ALTERNATIVE_ENDPOINT_CERTIFICATE_PROVIDER = Flags.defineFeatureFlag("use-alternative-endpoint-certificate-provider", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to use an alternative CA when provisioning new certificates", "Takes effect only on initial application deployment - not on later certificate refreshes!", new FetchVector.Dimension[0]);
    public static final UnboundStringFlag DOCKER_IMAGE_REPO = Flags.defineStringFlag("docker-image-repo", "", List.of("nobody"), "2020-12-02", "2021-02-01", "Override default docker image repo. Docker image version will be Vespa version.", "Takes effect on next deployment from controller", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag YUM_DIST_HOST = Flags.defineStringFlag("yum-dist-host", "", List.of("aressem"), "2020-12-02", "2021-02-01", "Override the default dist host for yum.", "Takes effect on next tick or on host-admin restart (may vary where used).", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag ENDPOINT_CERT_IN_SHARED_ROUTING = Flags.defineFeatureFlag("endpoint-cert-in-shared-routing", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to provision and use endpoint certs for apps in shared routing zones", "Takes effect on next deployment of the application", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag PROVISION_APPLICATION_ROLES = Flags.defineFeatureFlag("provision-application-roles", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether application roles should be provisioned", "Takes effect on next deployment (controller)", FetchVector.Dimension.ZONE_ID);
    public static final UnboundBooleanFlag APPLICATION_IAM_ROLE = Flags.defineFeatureFlag("application-iam-roles", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Allow separate iam roles when provisioning/assigning hosts", "Takes effect immediately on new hosts, on next redeploy for applications", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_PUBLIC_SIGNUP_FLOW = Flags.defineFeatureFlag("enable-public-signup-flow", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Show the public signup flow for a user in the console", "takes effect on browser reload of api/user/v1/user", FetchVector.Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundBooleanFlag CONTROLLER_PROVISION_LB = Flags.defineFeatureFlag("controller-provision-lb", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Provision load balancer for controller cluster", "Takes effect when controller application is redeployed", FetchVector.Dimension.ZONE_ID);
    public static final UnboundIntFlag TENANT_NODE_QUOTA = Flags.defineIntFlag("tenant-node-quota", 5, List.of("nobody"), "2020-12-02", "2021-02-01", "The number of nodes a tenant is allowed to request per cluster", "Only takes effect on next deployment, if set to a value other than the default for flag!", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag TENANT_BUDGET_QUOTA = Flags.defineIntFlag("tenant-budget-quota", -1, List.of("nobody"), "2020-12-02", "2021-02-01", "The budget in cents/hr a tenant is allowed spend per instance, as calculated by NodeResources", "Only takes effect on next deployment, if set to a value other than the default for flag!", FetchVector.Dimension.TENANT_ID);
    public static final UnboundBooleanFlag ONLY_PUBLIC_ACCESS = Flags.defineFeatureFlag("enable-public-only", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Only access public hosts from container", "Takes effect on next tick", new FetchVector.Dimension[0]);
    public static final UnboundListFlag<String> OUTBOUND_BLOCKED_IPV4 = Flags.defineListFlag("container-outbound-blocked-ipv4", List.of(), String.class, List.of("nobody"), "2020-12-02", "2021-02-01", "List of IPs or CIDRs that are blocked for outbound connections", "Takes effect on next tick", new FetchVector.Dimension[0]);
    public static final UnboundListFlag<String> OUTBOUND_BLOCKED_IPV6 = Flags.defineListFlag("container-outbound-blocked-ipv6", List.of(), String.class, List.of("nobody"), "2020-12-02", "2021-02-01", "List of IPs or CIDRs that are blocked for outbound connections", "Takes effect on next tick", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag HIDE_SHARED_ROUTING_ENDPOINT = Flags.defineFeatureFlag("hide-shared-routing-endpoint", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether the controller should hide shared routing layer endpoint", "Takes effect immediately", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MAINTENANCE_DEPLOYMENT = Flags.defineFeatureFlag("node-repository-skip-maintenance-deployment", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether PeriodicApplicationMaintainer should skip deployment for an application", "Takes effect at next run of maintainer", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_ACCESS_CONTROL_CLIENT_AUTHENTICATION = Flags.defineFeatureFlag("use-access-control-client-authentication", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether application container should set up client authentication on default port based on access control element", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE = Flags.defineFeatureFlag("async-message-handling-on-schedule", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Optionally deliver async messages in own thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag CONTENT_NODE_BUCKET_DB_STRIPE_BITS = Flags.defineIntFlag("content-node-bucket-db-stripe-bits", 0, List.of("nobody"), "2020-12-02", "2021-02-01", "Number of bits used for striping the bucket DB in service layer", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MERGE_CHUNK_SIZE = Flags.defineIntFlag("merge-chunk-size", 0x400000, List.of("nobody"), "2020-12-02", "2021-02-01", "Size of merge buffer in service layer", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag FEED_CONCURRENCY = Flags.defineDoubleFlag("feed-concurrency", 0.5, List.of("nobody"), "2020-12-02", "2021-02-01", "How much concurrency should be allowed for feed", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_AUTOMATIC_REINDEXING = Flags.defineFeatureFlag("enable-automatic-reindexing", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to automatically trigger reindexing from config change", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_POWER_OF_TWO_CHOICES_LOAD_BALANCING = Flags.defineFeatureFlag("use-power-of-two-choices-load-balancing", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to use Power of two load balancing algorithm for application", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag DYNAMIC_RECONFIGURATION_OF_ZOOKEEPER_CLUSTER = Flags.defineFeatureFlag("dynamic-reconfiguration-of-zookeeper-cluster", false, List.of("nobody"), "2020-12-02", "2021-02-01", "Whether to allow dynamic reconfiguration of zookeeper cluster", "Takes effect on next deployment", FetchVector.Dimension.APPLICATION_ID);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundStringFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(FetchVector.Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, owners, Flags.parseDate(createdAt), Flags.parseDate(expiresAt), description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    private static Instant parseDate(String rawDate) {
        return DateTimeFormatter.ISO_DATE.parse((CharSequence)rawDate, LocalDate::from).atStartOfDay().toInstant(ZoneOffset.UTC);
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting() {
        return new Replacer();
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer() {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }
}

