/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostResources {
    private static final Set<String> validDiskSpeeds = Set.of("slow", "fast");
    private static final Set<String> validStorageTypes = Set.of("remote", "local");
    private final double vcpu;
    private final double memoryGb;
    private final double diskGb;
    private final double bandwidthGbps;
    private final String diskSpeed;
    private final String storageType;
    private final int containers;

    @JsonCreator
    public HostResources(@JsonProperty(value="vcpu") Double vcpu, @JsonProperty(value="memoryGb") Double memoryGb, @JsonProperty(value="diskGb") Double diskGb, @JsonProperty(value="bandwidthGbps") Double bandwidthGbps, @JsonProperty(value="diskSpeed") String diskSpeed, @JsonProperty(value="storageType") String storageType, @JsonProperty(value="containers") Integer containers) {
        this.vcpu = HostResources.requirePositive("vcpu", vcpu);
        this.memoryGb = HostResources.requirePositive("memoryGb", memoryGb);
        this.diskGb = HostResources.requirePositive("diskGb", diskGb);
        this.bandwidthGbps = HostResources.requirePositive("bandwidthGbps", Optional.ofNullable(bandwidthGbps).orElse(0.3));
        this.diskSpeed = HostResources.validateEnum("diskSpeed", validDiskSpeeds, diskSpeed);
        this.storageType = HostResources.validateEnum("storageType", validStorageTypes, storageType);
        this.containers = HostResources.requirePositive("containers", containers);
    }

    @JsonProperty(value="vcpu")
    public double vcpu() {
        return this.vcpu;
    }

    @JsonProperty(value="memoryGb")
    public double memoryGb() {
        return this.memoryGb;
    }

    @JsonProperty(value="diskGb")
    public double diskGb() {
        return this.diskGb;
    }

    @JsonProperty(value="bandwidthGbps")
    public double bandwidthGbps() {
        return this.bandwidthGbps;
    }

    @JsonProperty(value="diskSpeed")
    public String diskSpeed() {
        return this.diskSpeed;
    }

    @JsonProperty(value="storageType")
    public String storageType() {
        return this.storageType;
    }

    @JsonProperty(value="containers")
    public int containers() {
        return this.containers;
    }

    private static double requirePositive(String name, Double value) {
        HostResources.requireNonNull(name, value);
        if (value <= 0.0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    private static int requirePositive(String name, Integer value) {
        HostResources.requireNonNull(name, value);
        if (value <= 0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    private static String validateEnum(String name, Set<String> validValues, String value) {
        HostResources.requireNonNull(name, value);
        if (!validValues.contains(value)) {
            throw new IllegalArgumentException("Invalid " + name + ", valid values are: " + validValues + ", got: " + value);
        }
        return value;
    }

    private static <T> T requireNonNull(String name, T value) {
        return Objects.requireNonNull(value, () -> "'" + name + "' has not been specified");
    }

    public String toString() {
        return "HostResources{vcpu=" + this.vcpu + ", memoryGb=" + this.memoryGb + ", diskGb=" + this.diskGb + ", bandwidthGbps=" + this.bandwidthGbps + ", diskSpeed='" + this.diskSpeed + "', storageType='" + this.storageType + "', containers=" + this.containers + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostResources resources = (HostResources)o;
        return Double.compare(resources.vcpu, this.vcpu) == 0 && Double.compare(resources.memoryGb, this.memoryGb) == 0 && Double.compare(resources.diskGb, this.diskGb) == 0 && Double.compare(resources.bandwidthGbps, this.bandwidthGbps) == 0 && this.diskSpeed.equals(resources.diskSpeed) && this.storageType.equals(resources.storageType) && this.containers == resources.containers;
    }

    public int hashCode() {
        return Objects.hash(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.containers);
    }
}

