/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.yahoo.component.Version;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.json.Condition;
import com.yahoo.vespa.flags.json.DimensionHelper;
import com.yahoo.vespa.flags.json.RelationalPredicate;
import com.yahoo.vespa.flags.json.wire.WireCondition;
import java.util.function.Predicate;

public class RelationalCondition
implements Condition {
    private final RelationalPredicate relationalPredicate;
    private final Predicate<String> predicate;
    private final FetchVector.Dimension dimension;

    public static RelationalCondition create(Condition.CreateParams params) {
        if (!params.values().isEmpty()) {
            throw new IllegalArgumentException(RelationalCondition.class.getSimpleName() + " does not support the 'values' field");
        }
        String predicate = params.predicate().orElseThrow(() -> new IllegalArgumentException(RelationalCondition.class.getSimpleName() + " requires the predicate field in the condition"));
        RelationalPredicate relationalPredicate = RelationalPredicate.fromWire(predicate);
        switch (params.dimension()) {
            case VESPA_VERSION: {
                Version rightVersion = Version.fromString((String)relationalPredicate.rightOperand());
                Predicate<String> p = leftString -> {
                    Version leftVersion = Version.fromString((String)leftString);
                    return relationalPredicate.operator().evaluate(leftVersion, rightVersion);
                };
                return new RelationalCondition(relationalPredicate, p, params.dimension());
            }
        }
        throw new IllegalArgumentException(RelationalCondition.class.getSimpleName() + " not supported for dimension " + FetchVector.Dimension.VESPA_VERSION.name());
    }

    private RelationalCondition(RelationalPredicate relationalPredicate, Predicate<String> predicate, FetchVector.Dimension dimension) {
        this.relationalPredicate = relationalPredicate;
        this.predicate = predicate;
        this.dimension = dimension;
    }

    @Override
    public boolean test(FetchVector fetchVector) {
        return fetchVector.getValue(this.dimension).map(this.predicate::test).orElse(false);
    }

    @Override
    public WireCondition toWire() {
        WireCondition condition = new WireCondition();
        condition.type = Condition.Type.RELATIONAL.toWire();
        condition.dimension = DimensionHelper.toWire(this.dimension);
        condition.predicate = this.relationalPredicate.toWire();
        return condition;
    }
}

