/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import com.yahoo.vespa.flags.custom.HostCapacity;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundIntFlag DROP_CACHES = Flags.defineIntFlag("drop-caches", 3, "The int value to write into /proc/sys/vm/drop_caches for each tick. 1 is page cache, 2 is dentries inodes, 3 is both page cache and dentries inodes, etc.", "Takes effect on next tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_CROWDSTRIKE = Flags.defineFeatureFlag("enable-crowdstrike", true, "Whether to enable CrowdStrike.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_NESSUS = Flags.defineFeatureFlag("enable-nessus", true, "Whether to enable Nessus.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_FLEET_SSHD_CONFIG = Flags.defineFeatureFlag("enable-fleet-sshd-config", true, "Whether fleet should manage the /etc/ssh/sshd_config file.", "Takes effect on next host admin tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag FLEET_CANARY = Flags.defineFeatureFlag("fleet-canary", false, "Whether the host is a fleet canary.", "Takes effect on next host admin tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundListFlag<String> DISABLED_HOST_ADMIN_TASKS = Flags.defineListFlag("disabled-host-admin-tasks", List.of(), String.class, "List of host-admin task names (as they appear in the log, e.g. root>main>UpgradeTask), or some node-agent functionality (see NodeAgentTask), that should be skipped", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.NODE_TYPE);
    public static final UnboundStringFlag DOCKER_VERSION = Flags.defineStringFlag("docker-version", "1.13.1-102.git7f2769b", "The version of the docker to use of the format VERSION-REL: The YUM package to be installed will be 2:docker-VERSION-REL.el7.centos.x86_64 in AWS (and without '.centos' otherwise). If docker-version is not of this format, it must be parseable by YumPackageName::fromString.", "Takes effect on next tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundLongFlag THIN_POOL_GB = Flags.defineLongFlag("thin-pool-gb", -1L, "The size of the disk reserved for the thin pool with dynamic provisioning in AWS, in base-2 GB. If <0, the default is used (which may depend on the zone and node type).", "Takes effect immediately (but used only during provisioning).", FetchVector.Dimension.NODE_TYPE);
    public static final UnboundDoubleFlag CONTAINER_CPU_CAP = Flags.defineDoubleFlag("container-cpu-cap", 0.0, "Hard limit on how many CPUs a container may use. This value is multiplied by CPU allocated to node, so to cap CPU at 200%, set this to 2, etc.", "Takes effect on next node agent tick. Change is orchestrated, but does NOT require container restart", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag TLS_INSECURE_AUTHORIZATION_MODE = Flags.defineStringFlag("tls-insecure-authorization-mode", "log_only", "TLS insecure authorization mode. Allowed values: ['disable', 'log_only', 'enforce']", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundIntFlag REBOOT_INTERVAL_IN_DAYS = Flags.defineIntFlag("reboot-interval-in-days", 30, "No reboots are scheduled 0x-1x reboot intervals after the previous reboot, while reboot is scheduled evenly distributed in the 1x-2x range (and naturally guaranteed at the 2x boundary).", "Takes effect on next run of NodeRebooter", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag RETIRE_WITH_PERMANENTLY_DOWN = Flags.defineFeatureFlag("retire-with-permanently-down", false, "If enabled, retirement will end with setting the host status to PERMANENTLY_DOWN, instead of ALLOWED_TO_BE_DOWN (old behavior).", "Takes effect on the next run of RetiredExpirer.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundListFlag<HostCapacity> TARGET_CAPACITY = Flags.defineListFlag("preprovision-capacity", List.of(), HostCapacity.class, "List of node resources and their count that should be provisioned.In a dynamically provisioned zone this specifies the unallocated (i.e. pre-provisioned) capacity. Otherwise it specifies the total (unallocated or not) capacity.", "Takes effect on next iteration of DynamicProvisioningMaintainer.", new FetchVector.Dimension[0]);
    public static final UnboundListFlag<String> INACTIVE_MAINTENANCE_JOBS = Flags.defineListFlag("inactive-maintenance-jobs", List.of(), String.class, "The list of maintenance jobs that are inactive.", "Takes effect immediately, but any currently running jobs will run until completion.", new FetchVector.Dimension[0]);
    public static final UnboundDoubleFlag DEFAULT_TERM_WISE_LIMIT = Flags.defineDoubleFlag("default-term-wise-limit", 1.0, "Default limit for when to apply termwise query evaluation", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag DEFAULT_THREADPOOL_SIZE_FACTOR = Flags.defineDoubleFlag("default-threadpool-size-factor", 0.0, "Default multiplication factor when computing maxthreads for main container threadpool based on available cores", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag DEFAULT_QUEUE_SIZE_FACTOR = Flags.defineDoubleFlag("default-queue-size-factor", 0.0, "Default multiplication factor when computing queuesize for burst handling", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag JVM_GC_OPTIONS = Flags.defineStringFlag("jvm-gc-options", "", "Sets deafult jvm gc options", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag FEED_SEQUENCER_TYPE = Flags.defineStringFlag("feed-sequencer-type", "LATENCY", "Selects type of sequenced executor used for feeding, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag RESPONSE_SEQUENCER_TYPE = Flags.defineStringFlag("response-sequencer-type", "ADAPTIVE", "Selects type of sequenced executor used for mbus responses, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag RESPONSE_NUM_THREADS = Flags.defineIntFlag("response-num-threads", 2, "Number of threads used for mbus responses, default is 2, negative number = numcores/4", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_COMMUNICATIONMANAGER_THREAD = Flags.defineFeatureFlag("skip-communicatiomanager-thread", false, "Should we skip the communicationmanager thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REQUEST_THREAD = Flags.defineFeatureFlag("skip-mbus-request-thread", false, "Should we skip the mbus request thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REPLY_THREAD = Flags.defineFeatureFlag("skip-mbus-reply-thread", false, "Should we skip the mbus reply thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_CONTENT_NODE_BTREE_DB = Flags.defineFeatureFlag("use-content-node-btree-db", false, "Whether to use the new B-tree bucket database on the content node.", "Takes effect at restart of content node process", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_THREE_PHASE_UPDATES = Flags.defineFeatureFlag("use-three-phase-updates", false, "Whether to enable the use of three-phase updates when bucket replicas are out of sync.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag HOST_HARDENING = Flags.defineFeatureFlag("host-hardening", false, "Whether to enable host hardening Linux baseline.", "Takes effect on next tick or on host-admin restart (may vary where used).", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag TCP_ABORT_ON_OVERFLOW = Flags.defineFeatureFlag("tcp-abort-on-overflow", false, "Whether to set /proc/sys/net/ipv4/tcp_abort_on_overflow to 0 (false) or 1 (true)", "Takes effect on next host-admin tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag ZOOKEEPER_SERVER_VERSION = Flags.defineStringFlag("zookeeper-server-version", "3.5.6", "ZooKeeper server version, a jar file zookeeper-server-<ZOOKEEPER_SERVER_VERSION>-jar-with-dependencies.jar must exist", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_FOR_ZOOKEEPER_CLIENT_SERVER_COMMUNICATION = Flags.defineStringFlag("tls-for-zookeeper-client-server-communication", "OFF", "How to setup TLS for ZooKeeper client/server communication. Valid values are OFF, PORT_UNIFICATION, TLS_WITH_PORT_UNIFICATION, TLS_ONLY", "Takes effect on restart of config server", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_TLS_FOR_ZOOKEEPER_CLIENT = Flags.defineFeatureFlag("use-tls-for-zookeeper-client", false, "Whether to use TLS for ZooKeeper clients", "Takes effect on restart of process", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_DISK_WRITE_TEST = Flags.defineFeatureFlag("enable-disk-write-test", true, "Regularly issue a small write to disk and fail the host if it is not successful", "Takes effect on next node agent tick (but does not clear existing failure reports)", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_REFRESHED_ENDPOINT_CERTIFICATE = Flags.defineFeatureFlag("use-refreshed-endpoint-certificate", false, "Whether an application should start using a newer certificate/key pair if available", "Takes effect on the next deployment of the application", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag VALIDATE_ENDPOINT_CERTIFICATES = Flags.defineFeatureFlag("validate-endpoint-certificates", false, "Whether endpoint certificates should be validated before use", "Takes effect on the next deployment of the application", new FetchVector.Dimension[0]);
    public static final UnboundStringFlag ENDPOINT_CERTIFICATE_BACKFILL = Flags.defineStringFlag("endpoint-certificate-backfill", "disable", "Whether the endpoint certificate maintainer should backfill missing certificate data from cameo", "Takes effect on next scheduled run of maintainer - set to \"disable\", \"dryrun\" or \"enable\"", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag USE_ALTERNATIVE_ENDPOINT_CERTIFICATE_PROVIDER = Flags.defineFeatureFlag("use-alternative-endpoint-certificate-provider", false, "Whether to use an alternative CA when provisioning new certificates", "Takes effect only on initial application deployment - not on later certificate refreshes!", new FetchVector.Dimension[0]);
    public static final UnboundStringFlag DOCKER_IMAGE_REPO = Flags.defineStringFlag("docker-image-repo", "", "Override default docker image repo. Docker image version will be Vespa version.", "Takes effect on next deployment from controller", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENDPOINT_CERT_IN_SHARED_ROUTING = Flags.defineFeatureFlag("endpoint-cert-in-shared-routing", false, "Whether to provision and use endpoint certs for apps in shared routing zones", "Takes effect on next deployment of the application", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag PHRASE_SEGMENTING = Flags.defineFeatureFlag("phrase-segmenting", false, "Should 'implicit phrases' in queries we parsed to a phrase or and?", "Takes effect on redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag NLB_PROXY_PROTOCOL = Flags.defineFeatureFlag("nlb-proxy-protocol", false, "Configure NLB to use proxy protocol", "Takes effect on next application redeploy", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_CLOUD_INIT_FORMAT = Flags.defineFeatureFlag("use-cloud-init", false, "Use the cloud-init format when provisioning hosts", "Takes effect immediately", FetchVector.Dimension.ZONE_ID);
    public static final UnboundBooleanFlag CONFIGSERVER_DISTRIBUTE_APPLICATION_PACKAGE = Flags.defineFeatureFlag("configserver-distribute-application-package", false, "Whether the application package should be distributed to other config servers during a deployment", "Takes effect immediately", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag PROVISION_APPLICATION_ROLES = Flags.defineFeatureFlag("provision-application-roles", false, "Whether application roles should be provisioned", "Takes effect on next deployment (controller)", FetchVector.Dimension.ZONE_ID);
    public static final UnboundBooleanFlag APPLICATION_IAM_ROLE = Flags.defineFeatureFlag("application-iam-roles", false, "Allow separate iam roles when provisioning/assigning hosts", "Takes effect immediately on new hosts, on next redeploy for applications", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_PUBLIC_SIGNUP_FLOW = Flags.defineFeatureFlag("enable-public-signup-flow", false, "Show the public signup flow for a user in the console", "takes effect on browser reload of api/user/v1/user", FetchVector.Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundBooleanFlag CONTROLLER_PROVISION_LB = Flags.defineFeatureFlag("controller-provision-lb", false, "Provision load balancer for controller cluster", "Takes effect when controller application is redeployed", FetchVector.Dimension.ZONE_ID);
    public static final UnboundIntFlag TENANT_NODE_QUOTA = Flags.defineIntFlag("tenant-node-quota", 5, "The number of nodes a tenant is allowed to request", "Takes effect on next deployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag WEIGHTED_DNS_PER_REGION = Flags.defineFeatureFlag("weighted-dns-per-region", true, "Whether to create weighted DNS records per region in global endpoints", "Takes effect on next deployment through controller", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ONLY_PUBLIC_ACCESS = Flags.defineFeatureFlag("enable-public-only", false, "Only access public hosts from container", "Takes effect on next tick", new FetchVector.Dimension[0]);
    public static final UnboundListFlag<String> OUTBOUND_BLOCKED_IPV4 = Flags.defineListFlag("container-outbound-blocked-ipv4", List.of(), String.class, "List of IPs or CIDRs that are blocked for outbound connections", "Takes effect on next tick", new FetchVector.Dimension[0]);
    public static final UnboundListFlag<String> OUTBOUND_BLOCKED_IPV6 = Flags.defineListFlag("container-outbound-blocked-ipv6", List.of(), String.class, "List of IPs or CIDRs that are blocked for outbound connections", "Takes effect on next tick", new FetchVector.Dimension[0]);
    public static final UnboundDoubleFlag FEED_CORE_THREAD_POOL_SIZE_FACTOR = Flags.defineDoubleFlag("feed-core-thread-pool-size-factor", 1.0, "Number of core threads in threadpool for feeding APIs as factor of max pool size", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_CONFIG_SERVER_LOCK = Flags.defineFeatureFlag("use-config-server-lock", false, "Whether the node-repository should take the same application lock as the config server when making changes to nodes", "Takes effect on config server restart", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag HIDE_SHARED_ROUTING_ENDPOINT = Flags.defineFeatureFlag("hide-shared-routing-endpoint", false, "Whether the controller should hide shared routing layer endpoint", "Takes effect immediately", FetchVector.Dimension.APPLICATION_ID);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundStringFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(FetchVector.Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting() {
        return new Replacer();
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer() {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }
}

