/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.yahoo.vespa.flags.json.RelationalOperator;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RelationalPredicate {
    private final String originalPredicateString;
    private final RelationalOperator operator;
    private final String rightOperand;

    public static RelationalPredicate fromWire(String predicateString) {
        List operatorsByDecendingLength = Stream.of(RelationalOperator.values()).sorted(Comparator.comparing(operator -> -operator.toText().length())).collect(Collectors.toList());
        for (RelationalOperator operator2 : operatorsByDecendingLength) {
            if (!predicateString.startsWith(operator2.toText())) continue;
            String suffix = predicateString.substring(operator2.toText().length());
            return new RelationalPredicate(predicateString, operator2, suffix);
        }
        throw new IllegalArgumentException("Predicate string '" + predicateString + "' does not start with a relation operator");
    }

    private RelationalPredicate(String originalPredicateString, RelationalOperator operator, String rightOperand) {
        this.originalPredicateString = originalPredicateString;
        this.operator = operator;
        this.rightOperand = rightOperand;
    }

    public RelationalOperator operator() {
        return this.operator;
    }

    public String rightOperand() {
        return this.rightOperand;
    }

    public String toWire() {
        return this.originalPredicateString;
    }
}

