/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NodeResources {
    private static final Set<String> validDiskSpeeds = Set.of("any", "slow", "fast");
    @JsonProperty(value="vcpu")
    private final double vcpu;
    @JsonProperty(value="memoryGb")
    private final double memoryGb;
    @JsonProperty(value="diskGb")
    private final double diskGb;
    @JsonProperty(value="bandwidthGbps")
    private final double bandwidthGbps;
    @JsonProperty(value="diskSpeed")
    private final String diskSpeed;

    public NodeResources(@JsonProperty(value="vcpu") double vcpu, @JsonProperty(value="memoryGb") double memoryGb, @JsonProperty(value="diskGb") double diskGb, @JsonProperty(value="bandwidthGbps") Double bandwidthGbps, @JsonProperty(value="diskSpeed") String diskSpeed) {
        this.vcpu = NodeResources.requirePositive("vcpu", vcpu);
        this.memoryGb = NodeResources.requirePositive("memoryGb", memoryGb);
        this.diskGb = NodeResources.requirePositive("diskGb", diskGb);
        this.bandwidthGbps = (int)NodeResources.requirePositive("bandwidthGbps", Optional.ofNullable(bandwidthGbps).orElse(0.3));
        this.diskSpeed = Optional.ofNullable(diskSpeed).orElse("fast");
        if (!validDiskSpeeds.contains(this.diskSpeed)) {
            throw new IllegalArgumentException("Invalid diskSpeed, valid values are: " + validDiskSpeeds + ", got: " + diskSpeed);
        }
    }

    public double vcpu() {
        return this.vcpu;
    }

    public double memoryGb() {
        return this.memoryGb;
    }

    public double diskGb() {
        return this.diskGb;
    }

    public double bandwidthGbps() {
        return this.bandwidthGbps;
    }

    public String diskSpeed() {
        return this.diskSpeed;
    }

    private static double requirePositive(String name, double value) {
        if (value < 1.0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeResources resources = (NodeResources)o;
        return Double.compare(resources.vcpu, this.vcpu) == 0 && Double.compare(resources.memoryGb, this.memoryGb) == 0 && Double.compare(resources.diskGb, this.diskGb) == 0 && Double.compare(resources.bandwidthGbps, this.bandwidthGbps) == 0 && this.diskSpeed.equals(resources.diskSpeed);
    }

    public int hashCode() {
        return Objects.hash(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed);
    }
}

