/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.RawFlag;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryFlagSource
implements FlagSource {
    private final Map<FlagId, RawFlag> rawFlagsById = new ConcurrentHashMap<FlagId, RawFlag>();

    public InMemoryFlagSource withBooleanFlag(FlagId flagId, boolean value) {
        return this.withRawFlag(flagId, new UnboundBooleanFlag(flagId, value).serializer().serialize(value));
    }

    public InMemoryFlagSource withStringFlag(FlagId flagId, String value) {
        return this.withRawFlag(flagId, new UnboundStringFlag(flagId, value).serializer().serialize(value));
    }

    public InMemoryFlagSource withIntFlag(FlagId flagId, int value) {
        return this.withRawFlag(flagId, new UnboundIntFlag(flagId, value).serializer().serialize(value));
    }

    public InMemoryFlagSource withLongFlag(FlagId flagId, long value) {
        return this.withRawFlag(flagId, new UnboundLongFlag(flagId, value).serializer().serialize(value));
    }

    public InMemoryFlagSource withDoubleFlag(FlagId flagId, double value) {
        return this.withRawFlag(flagId, new UnboundDoubleFlag(flagId, value).serializer().serialize(value));
    }

    public <T> InMemoryFlagSource withJacksonFlag(FlagId flagId, T value, Class<T> jacksonClass) {
        return this.withRawFlag(flagId, new UnboundJacksonFlag<T>(flagId, value, jacksonClass).serializer().serialize(value));
    }

    @Deprecated
    public InMemoryFlagSource withListFlag(FlagId flagId, List<String> value) {
        return this.withListFlag(flagId, value, String.class);
    }

    public <T> InMemoryFlagSource withListFlag(FlagId flagId, List<T> value, Class<T> elementClass) {
        return this.withRawFlag(flagId, new UnboundListFlag<T>(flagId, value, elementClass).serializer().serialize(value));
    }

    public InMemoryFlagSource removeFlag(FlagId flagId) {
        this.rawFlagsById.remove(flagId);
        return this;
    }

    private InMemoryFlagSource withRawFlag(FlagId flagId, RawFlag rawFlag) {
        this.rawFlagsById.put(flagId, rawFlag);
        return this;
    }

    @Override
    public Optional<RawFlag> fetch(FlagId id, FetchVector vector) {
        return Optional.ofNullable(this.rawFlagsById.get(id));
    }
}

