/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundBooleanFlag HEALTHMONITOR_MONITOR_INFRA = Flags.defineFeatureFlag("healthmonitor-monitorinfra", true, "Whether the health monitor in service monitor monitors the health of infrastructure applications.", "Affects all applications activated after the value is changed.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag DUPERMODEL_CONTAINS_INFRA = Flags.defineFeatureFlag("dupermodel-contains-infra", true, "Whether the DuperModel in config server/controller includes active infrastructure applications (except from controller/config apps).", "Requires restart of config server/controller to take effect.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag DUPERMODEL_USE_CONFIGSERVERCONFIG = Flags.defineFeatureFlag("dupermodel-use-configserverconfig", true, "For historical reasons, the ApplicationInfo in the DuperModel for controllers and config servers is based on the ConfigserverConfig (this flag is true). We want to transition to use the infrastructure application activated by the InfrastructureProvisioner once that supports health.", "Requires restart of config server/controller to take effect.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_CONFIG_SERVER_CACHE = Flags.defineFeatureFlag("use-config-server-cache", true, "Whether config server will use cache to answer config requests.", "Takes effect immediately when changed.", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag CONFIG_SERVER_BOOTSTRAP_IN_SEPARATE_THREAD = Flags.defineFeatureFlag("config-server-bootstrap-in-separate-thread", true, "Whether to run config server/controller bootstrap in a separate thread.", "Takes effect only at bootstrap of config server/controller", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag PROXYHOST_USES_REAL_ORCHESTRATOR = Flags.defineFeatureFlag("proxyhost-uses-real-orchestrator", true, "Whether proxy hosts uses the real Orchestrator when suspending/resuming, or a synthetic.", "Takes effect immediately when changed.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag CONFIGHOST_USES_REAL_ORCHESTRATOR = Flags.defineFeatureFlag("confighost-uses-real-orchestrator", true, "Whether the config server hosts uses the real Orchestrator when suspending/resuming, or a synthetic.", "Takes effect immediately when changed.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_CROWDSTRIKE = Flags.defineFeatureFlag("enable-crowdstrike", true, "Whether to enable CrowdStrike.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_NESSUS = Flags.defineFeatureFlag("enable-nessus", true, "Whether to enable Nessus.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundStringFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    public static List<FlagDefinition> getAllFlags() {
        return new ArrayList<FlagDefinition>(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting() {
        return new Replacer();
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer() {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }
}

