/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSource;
import java.util.function.Function;

public class FeatureFlag
implements Flag {
    private final boolean defaultValue;
    private final FlagId id;
    private final FlagSource source;

    public static Function<FlagSource, FeatureFlag> createUnbound(String flagId, boolean defaultValue) {
        return FeatureFlag.createUnbound(new FlagId(flagId), defaultValue);
    }

    public static Function<FlagSource, FeatureFlag> createUnbound(FlagId id, boolean defaultValue) {
        return source -> new FeatureFlag(id, defaultValue, (FlagSource)source);
    }

    public FeatureFlag(String flagId, boolean defaultValue, FlagSource source) {
        this(new FlagId(flagId), defaultValue, source);
    }

    public FeatureFlag(FlagId id, boolean defaultValue, FlagSource source) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.source = source;
    }

    @Override
    public FlagId id() {
        return this.id;
    }

    public boolean value() {
        return this.source.getString(this.id).map(FeatureFlag::booleanFromString).orElse(this.defaultValue);
    }

    private static boolean booleanFromString(String string) {
        String canonicalString = string.trim().toLowerCase();
        if (canonicalString.equals("true")) {
            return true;
        }
        if (canonicalString.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException("Unable to convert to true or false: '" + string + "'");
    }

    public String toString() {
        return "IntFlag{id=" + this.id + ", defaultValue=" + this.defaultValue + ", source=" + this.source + '}';
    }
}

