/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

public enum FileApiErrorCodes {
    OK(0, "OK"),
    NOT_FOUND(1, "File reference not found"),
    TIMEOUT(2, "Timeout"),
    TRANSFER_FAILED(3, "Failed transferring file");

    private final int code;
    private final String description;

    private FileApiErrorCodes(int code, String description) {
        this.code = code;
        this.description = description;
    }

    static FileApiErrorCodes get(int code) {
        for (FileApiErrorCodes error : FileApiErrorCodes.values()) {
            if (error.code() != code) continue;
            return error;
        }
        return null;
    }

    public int code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return this.code + ": " + this.description;
    }
}

