/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.compress.ZstdOutputStream;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import io.airlift.compress.zstd.ZstdInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class FileReferenceCompressor {
    private static final Logger log = Logger.getLogger(FileReferenceCompressor.class.getName());
    private static final int recurseDepth = 100;
    private final FileReferenceData.Type type;
    private final FileReferenceData.CompressionType compressionType;

    public FileReferenceCompressor(FileReferenceData.Type type, FileReferenceData.CompressionType compressionType) {
        this.type = Objects.requireNonNull(type, "Type cannot be null");
        this.compressionType = Objects.requireNonNull(compressionType, "Compression type cannot be null");
    }

    public File compress(File baseDir, List<File> inputFiles, File outputFile) throws IOException {
        TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream(this.compressedOutputStream(outputFile));
        archiveOutputStream.setLongFileMode(3);
        FileReferenceCompressor.createArchiveFile(archiveOutputStream, baseDir, inputFiles);
        return outputFile;
    }

    public File compress(File directory, File outputFile) throws IOException {
        try (Stream<Path> paths = Files.find(Path.of(directory.getAbsolutePath(), new String[0]), 100, (p, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]);){
            File file = this.compress(directory, paths.map(Path::toFile).toList(), outputFile);
            return file;
        }
    }

    public void decompress(File inputFile, File outputDir) throws IOException {
        log.log(Level.FINEST, () -> "Decompressing '" + inputFile + "' into '" + outputDir + "'");
        try (TarArchiveInputStream ais = new TarArchiveInputStream(this.decompressedInputStream(inputFile));){
            FileReferenceCompressor.decompress(ais, outputDir);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unable to decompress '" + inputFile.getAbsolutePath() + "': " + e.getMessage());
        }
    }

    private static void decompress(TarArchiveInputStream archiveInputStream, File outputFile) throws IOException {
        TarArchiveEntry entry;
        int entries = 0;
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            File outFile = new File(outputFile, entry.getName());
            if (entry.isDirectory()) {
                if (!outFile.exists() || !outFile.isDirectory()) {
                    log.log(Level.FINE, () -> "Creating dir: " + outFile.getAbsolutePath());
                    if (!outFile.mkdirs()) {
                        log.log(Level.WARNING, "Could not create dir " + entry.getName());
                    }
                }
            } else {
                File parent = new File(outFile.getParent());
                if (!parent.exists() && !parent.mkdirs()) {
                    log.log(Level.WARNING, "Could not create dir " + parent.getAbsolutePath());
                }
                try (FileOutputStream fos = new FileOutputStream(outFile);){
                    archiveInputStream.transferTo((OutputStream)fos);
                }
            }
            ++entries;
        }
        if (entries == 0) {
            throw new IllegalArgumentException("Not able to read any entries from stream (" + archiveInputStream.getBytesRead() + " bytes read from stream)");
        }
    }

    private static <T extends ArchiveEntry> void createArchiveFile(ArchiveOutputStream<T> archiveOutputStream, File baseDir, List<File> inputFiles) throws IOException {
        inputFiles.forEach(file -> {
            try {
                FileReferenceCompressor.writeFileToTar(archiveOutputStream, baseDir, file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        archiveOutputStream.close();
    }

    private static <T extends ArchiveEntry> void writeFileToTar(ArchiveOutputStream<T> taos, File baseDir, File file) throws IOException {
        taos.putArchiveEntry(taos.createArchiveEntry(file, baseDir.toPath().relativize(file.toPath()).toString()));
        try (FileInputStream inputStream = new FileInputStream(file);){
            inputStream.transferTo((OutputStream)taos);
        }
        taos.closeArchiveEntry();
    }

    private OutputStream compressedOutputStream(File outputFile) throws IOException {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case FileReferenceData.Type.compressed -> {
                switch (this.compressionType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case gzip: {
                        yield new GZIPOutputStream(new FileOutputStream(outputFile));
                    }
                    case lz4: {
                        yield new LZ4BlockOutputStream((OutputStream)new FileOutputStream(outputFile));
                    }
                    case zstd: 
                }
                yield new ZstdOutputStream((OutputStream)new FileOutputStream(outputFile));
            }
            case FileReferenceData.Type.file -> new FileOutputStream(outputFile);
        };
    }

    private InputStream decompressedInputStream(File inputFile) throws IOException {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case FileReferenceData.Type.compressed -> {
                switch (this.compressionType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case gzip: {
                        yield new GZIPInputStream(new FileInputStream(inputFile));
                    }
                    case lz4: {
                        yield new LZ4BlockInputStream((InputStream)new FileInputStream(inputFile));
                    }
                    case zstd: 
                }
                yield new ZstdInputStream((InputStream)new FileInputStream(inputFile));
            }
            case FileReferenceData.Type.file -> new FileInputStream(inputFile);
        };
    }
}

