/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import java.nio.ByteBuffer;

public abstract class FileReferenceData
implements AutoCloseable {
    private final FileReference fileReference;
    private final String filename;
    private final Type type;
    private final CompressionType compressionType;

    public FileReferenceData(FileReference fileReference, String filename, Type type, CompressionType compressionType) {
        this.fileReference = fileReference;
        this.filename = filename;
        this.type = type;
        this.compressionType = compressionType;
    }

    public FileReference fileReference() {
        return this.fileReference;
    }

    public String filename() {
        return this.filename;
    }

    public Type type() {
        return this.type;
    }

    public CompressionType compressionType() {
        return this.compressionType;
    }

    public ByteBuffer content() {
        ByteBuffer bb = ByteBuffer.allocate((int)this.size());
        while (bb.remaining() > 0) {
            this.nextContent(bb);
        }
        return bb;
    }

    public abstract int nextContent(ByteBuffer var1);

    public abstract long xxhash();

    public abstract long size();

    @Override
    public abstract void close();

    public String toString() {
        return this.fileReference.value() + " (" + this.filename + "), " + this.type.name();
    }

    public static enum Type {
        file,
        compressed;

    }

    public static enum CompressionType {
        gzip,
        lz4,
        zstd;

    }
}

