/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution.status;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.airline.Option;
import io.airlift.airline.SingleCommand;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class FileDistributionStatusClient {
    private static final String statusUnknown = "UNKNOWN";
    private static final String statusInProgress = "IN_PROGRESS";
    private static final String statusFinished = "FINISHED";
    private final String tenantName;
    private final String applicationName;
    private final String instanceName;
    private final String environment;
    private final String region;
    private final double timeout;
    private final boolean debug;

    FileDistributionStatusClient(CommandLineArguments arguments) {
        this.tenantName = arguments.getTenantName();
        this.applicationName = arguments.getApplicationName();
        this.instanceName = arguments.getInstanceName();
        this.environment = arguments.getEnvironment();
        this.region = arguments.getRegion();
        this.timeout = arguments.getTimeout();
        this.debug = arguments.getDebugFlag();
    }

    public static void main(String[] args) {
        try {
            new FileDistributionStatusClient(CommandLineArguments.build(args)).run();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public void run() {
        String json = this.doHttpRequest();
        System.out.println(this.parseAndGenerateOutput(json));
    }

    private String doHttpRequest() {
        int timeoutInMillis = (int)(this.timeout * 1000.0);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeoutInMillis).setConnectionRequestTimeout(timeoutInMillis).setSocketTimeout(timeoutInMillis).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        URI statusUri = this.createStatusApiUri();
        if (this.debug) {
            System.out.println("URI:" + statusUri);
        }
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(statusUri));
            String content = EntityUtils.toString((HttpEntity)response.getEntity());
            if (this.debug) {
                System.out.println("response:" + content);
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                return content;
            }
            throw new RuntimeException("Failed to get status for request " + statusUri + ": " + response.getStatusLine() + ": " + content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String parseAndGenerateOutput(String json) {
        String status;
        JsonNode jsonNode;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonNode = objectMapper.readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        switch (status = jsonNode.get("status").asText()) {
            case "UNKNOWN": {
                return "File distribution status unknown: " + jsonNode.get("message").asText();
            }
            case "IN_PROGRESS": {
                return "File distribution in progress:\n" + this.inProgressOutput(jsonNode.get("hosts"));
            }
            case "FINISHED": {
                return "File distribution finished";
            }
        }
        throw new RuntimeException("Unknown status " + status);
    }

    private URI createStatusApiUri() {
        String path = String.format("/application/v2/tenant/%s/application/%s/environment/%s/region/%s/instance/%s/filedistributionstatus", this.tenantName, this.applicationName, this.environment, this.region, this.instanceName);
        try {
            return new URIBuilder().setScheme("http").setHost("localhost").setPort(19071).setPath(path).addParameter("timeout", String.valueOf(this.timeout)).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String inProgressOutput(JsonNode hosts) {
        ArrayList<String> statusPerHost = new ArrayList<String>();
        for (JsonNode host : hosts) {
            String status = host.get("status").asText();
            StringBuilder sb = new StringBuilder(host.get("hostname").asText()).append(": ").append(status);
            switch (status) {
                case "UNKNOWN": {
                    sb.append(" (").append(host.get("message").asText()).append(")");
                    break;
                }
                case "IN_PROGRESS": {
                    JsonNode fileReferencesArray = host.get("fileReferences");
                    int finished = 0;
                    for (JsonNode element : fileReferencesArray) {
                        Iterator it = element.fields();
                        while (it.hasNext()) {
                            Map.Entry fileReferenceStatus = (Map.Entry)it.next();
                            if (((JsonNode)fileReferenceStatus.getValue()).asDouble() != 1.0) continue;
                            ++finished;
                        }
                    }
                    sb.append(" (" + finished + " of " + fileReferencesArray.size() + " finished)");
                    break;
                }
                case "FINISHED": {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown status " + status);
                }
            }
            statusPerHost.add(sb.toString());
        }
        return String.join((CharSequence)"\n", statusPerHost);
    }

    @Command(name="vespa-status-filedistribution", description="Tool for getting file distribution status.")
    public static class CommandLineArguments {
        @Inject
        HelpOption helpOption;
        @Option(name={"--tenant"}, description="tenant name")
        private String tenantNameArg;
        @Option(name={"--application"}, description="application name")
        private String applicationNameArg;
        @Option(name={"--instance"}, description="instance name")
        private String instanceNameArg = "default";
        @Option(name={"--environment"}, description="environment name")
        private String environmentArg = "prod";
        @Option(name={"--region"}, description="region name")
        private String regionArg = "default";
        @Option(name={"--timeout"}, description="The timeout (in seconds).")
        private double timeoutArg = 5.0;
        @Option(name={"--debug"}, description="Print debug log.")
        private boolean debugArg;

        static CommandLineArguments build(String[] args) {
            CommandLineArguments arguments = null;
            try {
                arguments = (CommandLineArguments)SingleCommand.singleCommand(CommandLineArguments.class).parse(args);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.err.println("Use --help to show usage.\n");
                System.exit(1);
            }
            if (arguments.helpOption.showHelpIfRequested()) {
                System.exit(0);
            }
            if (arguments.getTenantName() == null) {
                System.err.println("'--tenant' not set.");
                System.exit(1);
            }
            if (arguments.getApplicationName() == null) {
                System.err.println("'--application' not set.");
                System.exit(1);
            }
            return arguments;
        }

        public String getTenantName() {
            return this.tenantNameArg;
        }

        public String getApplicationName() {
            return this.applicationNameArg;
        }

        public String getInstanceName() {
            return this.instanceNameArg;
        }

        public String getEnvironment() {
            return this.environmentArg;
        }

        public String getRegion() {
            return this.regionArg;
        }

        public double getTimeout() {
            return this.timeoutArg;
        }

        public boolean getDebugFlag() {
            return this.debugArg;
        }
    }
}

