/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import java.nio.ByteBuffer;
import net.jpountz.xxhash.XXHashFactory;

public class FileReferenceDataBlob
extends FileReferenceData {
    private final byte[] content;
    private final long xxhash;
    private int contentRead = 0;

    public FileReferenceDataBlob(FileReference fileReference, String filename, FileReferenceData.Type type, byte[] content) {
        this(fileReference, filename, type, content, XXHashFactory.fastestInstance().hash64().hash(ByteBuffer.wrap(content), 0L));
    }

    public FileReferenceDataBlob(FileReference fileReference, String filename, FileReferenceData.Type type, byte[] content, long xxhash) {
        super(fileReference, filename, type);
        this.content = content;
        this.xxhash = xxhash;
    }

    public static FileReferenceData empty(FileReference fileReference, String filename) {
        return new FileReferenceDataBlob(fileReference, filename, FileReferenceData.Type.file, new byte[0], 0L);
    }

    @Override
    public ByteBuffer content() {
        return ByteBuffer.wrap(this.content);
    }

    @Override
    public int nextContent(ByteBuffer bb) {
        if (this.contentRead >= this.content.length) {
            return -1;
        }
        int left = this.content.length - this.contentRead;
        int size = Math.min(bb.remaining(), left);
        bb.put(this.content, this.contentRead, size);
        this.contentRead += size;
        return size;
    }

    @Override
    public long xxhash() {
        return this.xxhash;
    }

    @Override
    public long size() {
        return this.content.length;
    }

    @Override
    public void close() {
    }
}

