/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.FileReference;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.filedistribution.Downloads;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileReferenceDownloader {
    private static final Logger log = Logger.getLogger(FileReferenceDownloader.class.getName());
    private final ExecutorService downloadExecutor = Executors.newFixedThreadPool(Math.max(8, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new DaemonThreadFactory("filereference downloader"));
    private final ConnectionPool connectionPool;
    private final Downloads downloads;
    private final Duration downloadTimeout;
    private final Duration sleepBetweenRetries;
    private final Duration rpcTimeout;
    private final File downloadDirectory;

    FileReferenceDownloader(ConnectionPool connectionPool, Downloads downloads, Duration timeout, Duration sleepBetweenRetries, File downloadDirectory) {
        this.connectionPool = connectionPool;
        this.downloads = downloads;
        this.downloadTimeout = timeout;
        this.sleepBetweenRetries = sleepBetweenRetries;
        this.downloadDirectory = downloadDirectory;
        String timeoutString = System.getenv("VESPA_CONFIGPROXY_FILEDOWNLOAD_RPC_TIMEOUT");
        this.rpcTimeout = Duration.ofSeconds(timeoutString == null ? 30L : (long)Integer.parseInt(timeoutString));
    }

    private void waitUntilDownloadStarted(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        int retryCount = 0;
        do {
            if (FileDownloader.fileReferenceExists(fileReference, this.downloadDirectory)) {
                return;
            }
            if (this.startDownloadRpc(fileReferenceDownload, retryCount)) {
                return;
            }
            try {
                Thread.sleep(this.sleepBetweenRetries.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (++retryCount < 5);
        fileReferenceDownload.future().completeExceptionally(new RuntimeException("Failed getting " + fileReference));
        this.downloads.remove(fileReference);
    }

    Future<Optional<File>> startDownload(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        Optional<FileReferenceDownload> inProgress = this.downloads.get(fileReference);
        if (inProgress.isPresent()) {
            return inProgress.get().future();
        }
        log.log(Level.FINE, () -> "Will download file reference '" + fileReference.value() + "' with timeout " + this.downloadTimeout);
        this.downloads.add(fileReferenceDownload);
        this.downloadExecutor.submit(() -> this.waitUntilDownloadStarted(fileReferenceDownload));
        return fileReferenceDownload.future();
    }

    void failedDownloading(FileReference fileReference) {
        this.downloads.remove(fileReference);
    }

    private boolean startDownloadRpc(FileReferenceDownload fileReferenceDownload, int retryCount) {
        Request request = this.createRequest(fileReferenceDownload);
        Connection connection = this.connectionPool.getCurrent();
        connection.invokeSync(request, (double)this.rpcTimeout(retryCount).getSeconds());
        Level logLevel = retryCount > 3 ? Level.INFO : Level.FINE;
        FileReference fileReference = fileReferenceDownload.fileReference();
        if (this.validateResponse(request)) {
            log.log(Level.FINE, () -> "Request callback, OK. Req: " + request + "\nSpec: " + connection + ", retry count " + retryCount);
            if (request.returnValues().get(0).asInt32() == 0) {
                log.log(Level.FINE, () -> "Found '" + fileReference + "' available at " + connection.getAddress());
                return true;
            }
            log.log(logLevel, "'" + fileReference + "' not found at " + connection.getAddress());
            this.connectionPool.switchConnection(connection);
            return false;
        }
        log.log(logLevel, "Downloading " + fileReference + " from " + connection.getAddress() + " failed: " + request + ", error: " + request.errorMessage() + ", will switch config server for next request (retry " + retryCount + ", rpc timeout " + this.rpcTimeout(retryCount));
        this.connectionPool.switchConnection(connection);
        return false;
    }

    private Request createRequest(FileReferenceDownload fileReferenceDownload) {
        Request request = new Request("filedistribution.serveFile");
        request.parameters().add((Value)new StringValue(fileReferenceDownload.fileReference().value()));
        request.parameters().add((Value)new Int32Value(fileReferenceDownload.downloadFromOtherSourceIfNotFound() ? 0 : 1));
        return request;
    }

    private Duration rpcTimeout(int retryCount) {
        return Duration.ofSeconds(this.rpcTimeout.getSeconds()).plus(Duration.ofSeconds((long)retryCount * 10L));
    }

    private boolean validateResponse(Request request) {
        if (request.isError()) {
            return false;
        }
        if (request.returnValues().size() == 0) {
            return false;
        }
        if (!request.checkReturnTypes("is")) {
            log.log(Level.WARNING, "Invalid return types for response: " + request.errorMessage());
            return false;
        }
        return true;
    }

    public void close() {
        this.downloadExecutor.shutdown();
        try {
            this.downloadExecutor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }
}

