/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.jrt.Supervisor;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.Downloads;
import com.yahoo.vespa.filedistribution.FileReceiver;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.filedistribution.FileReferenceDownloader;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDownloader
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(FileDownloader.class.getName());
    private static final Duration defaultTimeout = Duration.ofMinutes(3L);
    private static final Duration defaultSleepBetweenRetries = Duration.ofSeconds(10L);
    public static final File defaultDownloadDirectory = new File(Defaults.getDefaults().underVespaHome("var/db/vespa/filedistribution"));
    private final ConnectionPool connectionPool;
    private final Supervisor supervisor;
    private final File downloadDirectory;
    private final Duration timeout;
    private final Duration sleepBetweenRetries;
    private final FileReferenceDownloader fileReferenceDownloader;
    private final Downloads downloads = new Downloads();

    public FileDownloader(ConnectionPool connectionPool, Supervisor supervisor) {
        this(connectionPool, supervisor, defaultDownloadDirectory, defaultTimeout, defaultSleepBetweenRetries);
    }

    public FileDownloader(ConnectionPool connectionPool, Supervisor supervisor, Duration timeout) {
        this(connectionPool, supervisor, defaultDownloadDirectory, timeout, defaultSleepBetweenRetries);
    }

    public FileDownloader(ConnectionPool connectionPool, Supervisor supervisor, File downloadDirectory) {
        this(connectionPool, supervisor, downloadDirectory, defaultTimeout, defaultSleepBetweenRetries);
    }

    public FileDownloader(ConnectionPool connectionPool, Supervisor supervisor, File downloadDirectory, Duration timeout, Duration sleepBetweenRetries) {
        this.connectionPool = connectionPool;
        this.supervisor = supervisor;
        this.downloadDirectory = downloadDirectory;
        this.timeout = timeout;
        this.sleepBetweenRetries = sleepBetweenRetries;
        new FileReceiver(supervisor, this.downloads, downloadDirectory);
        this.fileReferenceDownloader = new FileReferenceDownloader(connectionPool, this.downloads, timeout, sleepBetweenRetries, downloadDirectory);
    }

    public Optional<File> getFile(FileReference fileReference) {
        return this.getFile(new FileReferenceDownload(fileReference));
    }

    public Optional<File> getFile(FileReferenceDownload fileReferenceDownload) {
        try {
            return this.getFutureFile(fileReferenceDownload).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.log(Level.WARNING, "Failed downloading '" + fileReferenceDownload + "', removing from download queue: " + Exceptions.toMessageString((Throwable)e));
            this.fileReferenceDownloader.failedDownloading(fileReferenceDownload.fileReference());
            return Optional.empty();
        }
    }

    Future<Optional<File>> getFutureFile(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        Optional<File> file = this.getFileFromFileSystem(fileReference);
        if (file.isPresent()) {
            this.downloads.setDownloadStatus(fileReference, 1.0);
            return CompletableFuture.completedFuture(file);
        }
        return this.startDownload(fileReferenceDownload);
    }

    public Map<FileReference, Double> downloadStatus() {
        return this.downloads.downloadStatus();
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public Downloads downloads() {
        return this.downloads;
    }

    File downloadDirectory() {
        return this.downloadDirectory;
    }

    private Optional<File> getFileFromFileSystem(FileReference fileReference) {
        return FileDownloader.getFileFromFileSystem(fileReference, this.downloadDirectory);
    }

    private static Optional<File> getFileFromFileSystem(FileReference fileReference, File downloadDirectory) {
        File[] files = new File(downloadDirectory, fileReference.value()).listFiles();
        if (files == null) {
            return Optional.empty();
        }
        if (files.length == 0) {
            return Optional.empty();
        }
        if (files.length > 1) {
            throw new RuntimeException("More than one file reference found for " + fileReference);
        }
        File file = files[0];
        if (!file.exists()) {
            throw new RuntimeException("File reference '" + fileReference.value() + "' does not exist");
        }
        if (!file.canRead()) {
            throw new RuntimeException("File reference '" + fileReference.value() + "' exists, but unable to read it");
        }
        log.log(Level.FINE, () -> "File reference '" + fileReference.value() + "' found: " + file.getAbsolutePath());
        return Optional.of(file);
    }

    static boolean fileReferenceExists(FileReference fileReference, File downloadDirectory) {
        return FileDownloader.getFileFromFileSystem(fileReference, downloadDirectory).isPresent();
    }

    boolean isDownloading(FileReference fileReference) {
        return this.downloads.get(fileReference).isPresent();
    }

    public void downloadIfNeeded(FileReferenceDownload fileReferenceDownload) {
        if (FileDownloader.fileReferenceExists(fileReferenceDownload.fileReference(), this.downloadDirectory)) {
            return;
        }
        this.startDownload(fileReferenceDownload);
    }

    private synchronized Future<Optional<File>> startDownload(FileReferenceDownload fileReferenceDownload) {
        return this.fileReferenceDownloader.startDownload(fileReferenceDownload);
    }

    @Override
    public void close() {
        this.fileReferenceDownloader.close();
        this.supervisor.transport().shutdown().join();
    }

    public static ConnectionPool emptyConnectionPool() {
        return new EmptyConnectionPool();
    }

    private static class EmptyConnectionPool
    implements ConnectionPool {
        private EmptyConnectionPool() {
        }

        public void close() {
        }

        public Connection getCurrent() {
            return null;
        }

        public Connection switchConnection(Connection connection) {
            return null;
        }

        public int getSize() {
            return 0;
        }
    }
}

