/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.Downloads;
import com.yahoo.vespa.filedistribution.FileReceiver;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.filedistribution.FileReferenceDownloader;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDownloader
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(FileDownloader.class.getName());
    public static File defaultDownloadDirectory = new File(Defaults.getDefaults().underVespaHome("var/db/vespa/filedistribution"));
    private final ConnectionPool connectionPool;
    private final Supervisor supervisor;
    private final File downloadDirectory;
    private final Duration timeout;
    private final FileReferenceDownloader fileReferenceDownloader;
    private final Downloads downloads;

    public FileDownloader(List<String> configservers, Supervisor supervisor) {
        this(FileDownloader.getConnectionPool(configservers, supervisor), supervisor);
    }

    public FileDownloader(ConnectionPool connectionPool, Supervisor supervisor) {
        this(connectionPool, supervisor, defaultDownloadDirectory, new Downloads());
    }

    public FileDownloader(ConnectionPool connectionPool, Supervisor supervisor, File downloadDirectory, Downloads downloads) {
        this(connectionPool, supervisor, downloadDirectory, downloads, Duration.ofMinutes(5L), Duration.ofSeconds(10L));
    }

    public FileDownloader(ConnectionPool connectionPool, Supervisor supervisor, File downloadDirectory, Downloads downloads, Duration timeout, Duration sleepBetweenRetries) {
        this.connectionPool = connectionPool;
        this.supervisor = supervisor;
        this.downloadDirectory = downloadDirectory;
        this.timeout = timeout;
        new FileReceiver(supervisor, downloads, downloadDirectory);
        this.fileReferenceDownloader = new FileReferenceDownloader(connectionPool, downloads, timeout, sleepBetweenRetries);
        this.downloads = downloads;
    }

    public Optional<File> getFile(FileReference fileReference) {
        return this.getFile(new FileReferenceDownload(fileReference));
    }

    public Optional<File> getFile(FileReferenceDownload fileReferenceDownload) {
        try {
            return this.getFutureFile(fileReferenceDownload).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.log(Level.WARNING, "Failed downloading '" + fileReferenceDownload + "', removing from download queue: " + Exceptions.toMessageString((Throwable)e));
            this.fileReferenceDownloader.failedDownloading(fileReferenceDownload.fileReference());
            return Optional.empty();
        }
    }

    Future<Optional<File>> getFutureFile(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        Objects.requireNonNull(fileReference, "file reference cannot be null");
        Optional<File> file = this.getFileFromFileSystem(fileReference);
        return file.isPresent() ? CompletableFuture.completedFuture(file) : this.download(fileReferenceDownload);
    }

    public Map<FileReference, Double> downloadStatus() {
        return this.downloads.downloadStatus();
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    File downloadDirectory() {
        return this.downloadDirectory;
    }

    private Optional<File> getFileFromFileSystem(FileReference fileReference) {
        File[] files = new File(this.downloadDirectory, fileReference.value()).listFiles();
        if (files == null) {
            return Optional.empty();
        }
        if (files.length == 0) {
            return Optional.empty();
        }
        if (files.length > 1) {
            throw new RuntimeException("More than one file reference found for " + fileReference);
        }
        File file = files[0];
        if (!file.exists()) {
            throw new RuntimeException("File reference '" + fileReference.value() + "' does not exist");
        }
        if (!file.canRead()) {
            throw new RuntimeException("File reference '" + fileReference.value() + "' exists, but unable to read it");
        }
        log.log(Level.FINE, () -> "File reference '" + fileReference.value() + "' found: " + file.getAbsolutePath());
        this.downloads.setDownloadStatus(fileReference, 1.0);
        return Optional.of(file);
    }

    boolean isDownloading(FileReference fileReference) {
        return this.downloads.get(fileReference).isPresent();
    }

    private boolean alreadyDownloaded(FileReferenceDownload fileReferenceDownload) {
        try {
            return this.getFileFromFileSystem(fileReferenceDownload.fileReference()).isPresent();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void downloadIfNeeded(FileReferenceDownload fileReferenceDownload) {
        if (this.alreadyDownloaded(fileReferenceDownload)) {
            return;
        }
        this.download(fileReferenceDownload);
    }

    private synchronized Future<Optional<File>> download(FileReferenceDownload fileReferenceDownload) {
        return this.fileReferenceDownloader.download(fileReferenceDownload);
    }

    @Override
    public void close() {
        this.fileReferenceDownloader.close();
        this.supervisor.transport().shutdown().join();
    }

    private static ConnectionPool getConnectionPool(List<String> configServers, Supervisor supervisor) {
        return configServers.size() > 0 ? new JRTConnectionPool(new ConfigSourceSet(configServers), supervisor) : FileDownloader.emptyConnectionPool();
    }

    public static ConnectionPool emptyConnectionPool() {
        return new EmptyConnectionPool();
    }

    private static class EmptyConnectionPool
    implements ConnectionPool {
        private EmptyConnectionPool() {
        }

        public void close() {
        }

        public Connection getCurrent() {
            return null;
        }

        public Connection switchConnection(Connection connection) {
            return null;
        }

        public int getSize() {
            return 0;
        }
    }
}

