/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import java.io.File;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Downloads {
    private static final Logger log = Logger.getLogger(Downloads.class.getName());
    private final Map<FileReference, FileReferenceDownload> downloads = new ConcurrentHashMap<FileReference, FileReferenceDownload>();
    private final DownloadStatuses downloadStatuses = new DownloadStatuses();

    public DownloadStatuses downloadStatuses() {
        return this.downloadStatuses;
    }

    void setDownloadStatus(FileReference fileReference, double completeness) {
        this.downloadStatuses.put(fileReference, completeness);
    }

    void completedDownloading(FileReference fileReference, File file) {
        Optional<FileReferenceDownload> download = this.get(fileReference);
        this.setDownloadStatus(fileReference, 1.0);
        if (download.isPresent()) {
            this.downloads.remove(fileReference);
            download.get().future().complete(Optional.of(file));
        } else {
            log.log(Level.FINE, () -> "Received '" + fileReference + "', which was not requested. Can be ignored if happening during upgrades/restarts");
        }
    }

    void add(FileReferenceDownload fileReferenceDownload) {
        this.downloads.put(fileReferenceDownload.fileReference(), fileReferenceDownload);
        this.downloadStatuses.put(fileReferenceDownload.fileReference());
    }

    void remove(FileReference fileReference) {
        this.downloadStatuses.get(fileReference).ifPresent(d -> new DownloadStatus(d.fileReference(), 0.0));
        this.downloads.remove(fileReference);
    }

    double downloadStatus(FileReference fileReference) {
        double status = 0.0;
        Optional<DownloadStatus> downloadStatus = this.downloadStatuses.get(fileReference);
        if (downloadStatus.isPresent()) {
            status = downloadStatus.get().progress();
        }
        return status;
    }

    Map<FileReference, Double> downloadStatus() {
        return this.downloadStatuses.all().values().stream().collect(Collectors.toMap(DownloadStatus::fileReference, DownloadStatus::progress));
    }

    Optional<FileReferenceDownload> get(FileReference fileReference) {
        return Optional.ofNullable(this.downloads.get(fileReference));
    }

    static class DownloadStatus {
        private final FileReference fileReference;
        private final double progress;
        private final Instant created;

        DownloadStatus(FileReference fileReference, double progress) {
            this.fileReference = fileReference;
            this.progress = progress;
            this.created = Instant.now();
        }

        public FileReference fileReference() {
            return this.fileReference;
        }

        public double progress() {
            return this.progress;
        }

        public Instant created() {
            return this.created;
        }
    }

    static class DownloadStatuses {
        private static final int maxEntries = 100;
        private final Map<FileReference, DownloadStatus> downloadStatus = Collections.synchronizedMap(new HashMap());

        DownloadStatuses() {
        }

        void put(FileReference fileReference) {
            this.put(fileReference, 0.0);
        }

        void put(FileReference fileReference, double progress) {
            this.downloadStatus.put(fileReference, new DownloadStatus(fileReference, progress));
            if (this.downloadStatus.size() > 100) {
                Map.Entry oldest = Collections.min(this.downloadStatus.entrySet(), Comparator.comparing(e -> ((DownloadStatus)e.getValue()).created));
                this.downloadStatus.remove(oldest.getKey());
            }
        }

        Optional<DownloadStatus> get(FileReference fileReference) {
            return Optional.ofNullable(this.downloadStatus.get(fileReference));
        }

        Map<FileReference, DownloadStatus> all() {
            return Map.copyOf(this.downloadStatus);
        }

        public String toString() {
            return this.downloadStatus.entrySet().stream().map(entry -> ((FileReference)entry.getKey()).value() + "=>" + ((DownloadStatus)entry.getValue()).progress).collect(Collectors.joining(", "));
        }
    }
}

