/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import java.io.File;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Downloads {
    private static final Logger log = Logger.getLogger(Downloads.class.getName());
    private final Map<FileReference, FileReferenceDownload> downloads = new ConcurrentHashMap<FileReference, FileReferenceDownload>();
    private final DownloadStatuses downloadStatuses = new DownloadStatuses();

    public DownloadStatuses downloadStatuses() {
        return this.downloadStatuses;
    }

    void setDownloadStatus(FileReference fileReference, double completeness) {
        Optional<DownloadStatus> downloadStatus = this.downloadStatuses.get(fileReference);
        if (downloadStatus.isPresent()) {
            downloadStatus.get().setProgress(completeness);
        } else {
            this.downloadStatuses.add(fileReference, completeness);
        }
    }

    void completedDownloading(FileReference fileReference, File file) {
        Optional<FileReferenceDownload> download = this.get(fileReference);
        if (download.isPresent()) {
            this.downloadStatuses().get(fileReference).ifPresent(DownloadStatus::finished);
            this.downloads.remove(fileReference);
            download.get().future().complete(Optional.of(file));
        } else {
            log.log(Level.FINE, () -> "Received '" + fileReference + "', which was not requested. Can be ignored if happening during upgrades/restarts");
        }
    }

    void add(FileReferenceDownload fileReferenceDownload) {
        this.downloads.put(fileReferenceDownload.fileReference(), fileReferenceDownload);
        this.downloadStatuses.add(fileReferenceDownload.fileReference());
    }

    void remove(FileReference fileReference) {
        this.downloadStatuses.get(fileReference).ifPresent(d -> d.setProgress(0.0));
        this.downloads.remove(fileReference);
    }

    double downloadStatus(FileReference fileReference) {
        double status = 0.0;
        Optional<DownloadStatus> downloadStatus = this.downloadStatuses.get(fileReference);
        if (downloadStatus.isPresent()) {
            status = downloadStatus.get().progress();
        }
        return status;
    }

    Map<FileReference, Double> downloadStatus() {
        return this.downloadStatuses.all().values().stream().collect(Collectors.toMap(DownloadStatus::fileReference, DownloadStatus::progress));
    }

    Optional<FileReferenceDownload> get(FileReference fileReference) {
        return Optional.ofNullable(this.downloads.get(fileReference));
    }

    static class DownloadStatus {
        private final FileReference fileReference;
        private double progress;
        private final Instant created;

        DownloadStatus(FileReference fileReference) {
            this.fileReference = fileReference;
            this.progress = 0.0;
            this.created = Instant.now();
        }

        public FileReference fileReference() {
            return this.fileReference;
        }

        public double progress() {
            return this.progress;
        }

        public void setProgress(double progress) {
            this.progress = progress;
        }

        public void finished() {
            this.setProgress(1.0);
        }

        public Instant created() {
            return this.created;
        }
    }

    static class DownloadStatuses {
        private static final int maxEntries = 100;
        private final Map<FileReference, DownloadStatus> downloadStatus = new ConcurrentHashMap<FileReference, DownloadStatus>();

        DownloadStatuses() {
        }

        void add(FileReference fileReference) {
            this.add(fileReference, 0.0);
        }

        void add(FileReference fileReference, double progress) {
            DownloadStatus ds = new DownloadStatus(fileReference);
            ds.setProgress(progress);
            this.downloadStatus.put(fileReference, ds);
            if (this.downloadStatus.size() > 100) {
                Map.Entry oldest = Collections.min(this.downloadStatus.entrySet(), Comparator.comparing(e -> ((DownloadStatus)e.getValue()).created));
                this.downloadStatus.remove(oldest.getKey());
            }
        }

        Optional<DownloadStatus> get(FileReference fileReference) {
            return Optional.ofNullable(this.downloadStatus.get(fileReference));
        }

        Map<FileReference, DownloadStatus> all() {
            return Map.copyOf(this.downloadStatus);
        }
    }
}

