/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.FileReference;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.filedistribution.FileReceiver;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileReferenceDownloader {
    private static final Logger log = Logger.getLogger(FileReferenceDownloader.class.getName());
    private static final Duration rpcTimeout = Duration.ofSeconds(10L);
    private final ExecutorService downloadExecutor = Executors.newFixedThreadPool(Math.max(8, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new DaemonThreadFactory("filereference downloader"));
    private final ConnectionPool connectionPool;
    private final Map<FileReference, FileReferenceDownload> downloads = new LinkedHashMap<FileReference, FileReferenceDownload>();
    private final Map<FileReference, Double> downloadStatus = new HashMap<FileReference, Double>();
    private final Duration downloadTimeout;
    private final Duration sleepBetweenRetries;

    FileReferenceDownloader(File downloadDirectory, File tmpDirectory, ConnectionPool connectionPool, Duration timeout, Duration sleepBetweenRetries) {
        this.connectionPool = connectionPool;
        this.downloadTimeout = timeout;
        this.sleepBetweenRetries = sleepBetweenRetries;
        new FileReceiver(connectionPool.getSupervisor(), this, downloadDirectory, tmpDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDownload(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        Instant end = Instant.now().plus(this.downloadTimeout);
        boolean downloadStarted = false;
        int retryCount = 0;
        do {
            try {
                if (this.startDownloadRpc(fileReferenceDownload, retryCount)) {
                    downloadStarted = true;
                    continue;
                }
                ++retryCount;
                Thread.sleep(this.sleepBetweenRetries.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (Instant.now().isBefore(end) && !downloadStarted);
        if (!downloadStarted) {
            fileReferenceDownload.future().completeExceptionally(new RuntimeException("Failed getting file reference '" + fileReference.value() + "'"));
            Map<FileReference, FileReferenceDownload> map = this.downloads;
            synchronized (map) {
                this.downloads.remove(fileReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToDownloadQueue(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        log.log(Level.FINE, () -> "Will download file reference '" + fileReference.value() + "' with timeout " + this.downloadTimeout);
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            this.downloads.put(fileReference, fileReferenceDownload);
            this.downloadStatus.put(fileReference, 0.0);
        }
        this.downloadExecutor.submit(() -> this.startDownload(fileReferenceDownload));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completedDownloading(FileReference fileReference, File file) {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            FileReferenceDownload download = this.downloads.get(fileReference);
            if (download != null) {
                this.downloadStatus.put(fileReference, 1.0);
                this.downloads.remove(fileReference);
                download.future().complete(Optional.of(file));
            } else {
                log.log(Level.FINE, () -> "Received '" + fileReference + "', which was not requested. Can be ignored if happening during upgrades/restarts");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failedDownloading(FileReference fileReference) {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            this.downloadStatus.put(fileReference, 0.0);
            this.downloads.remove(fileReference);
        }
    }

    private boolean startDownloadRpc(FileReferenceDownload fileReferenceDownload, int retryCount) {
        Level logLevel;
        Connection connection = this.connectionPool.getCurrent();
        Request request = new Request("filedistribution.serveFile");
        String fileReference = fileReferenceDownload.fileReference().value();
        request.parameters().add((Value)new StringValue(fileReference));
        request.parameters().add((Value)new Int32Value(fileReferenceDownload.downloadFromOtherSourceIfNotFound() ? 0 : 1));
        connection.invokeSync(request, (double)rpcTimeout.getSeconds());
        Level level = logLevel = retryCount > 0 ? Level.INFO : Level.FINE;
        if (this.validateResponse(request)) {
            log.log(logLevel, () -> "Request callback, OK. Req: " + request + "\nSpec: " + connection + ", retry count " + retryCount);
            if (request.returnValues().get(0).asInt32() == 0) {
                log.log(logLevel, () -> "Found file reference '" + fileReference + "' available at " + connection.getAddress());
                return true;
            }
            log.log(logLevel, "File reference '" + fileReference + "' not found for " + connection.getAddress());
            this.connectionPool.setNewCurrentConnection();
            return false;
        }
        log.log(logLevel, () -> "Request failed. Req: " + request + "\nSpec: " + connection.getAddress() + ", error code: " + request.errorCode() + ", set error for spec, use another spec for next request, retry count " + retryCount);
        this.connectionPool.setError(connection, request.errorCode());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDownloading(FileReference fileReference) {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            return this.downloads.containsKey(fileReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileReferenceDownload getDownloadInProgress(FileReference fileReference) {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            return this.downloads.get(fileReference);
        }
    }

    private boolean validateResponse(Request request) {
        if (request.isError()) {
            return false;
        }
        if (request.returnValues().size() == 0) {
            return false;
        }
        if (!request.checkReturnTypes("is")) {
            log.log(Level.WARNING, "Invalid return types for response: " + request.errorMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double downloadStatus(String file) {
        double status = 0.0;
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            Double download = this.downloadStatus.get(new FileReference(file));
            if (download != null) {
                status = download;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDownloadStatus(FileReference fileReference, double completeness) {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            this.downloadStatus.put(fileReference, completeness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<FileReference, Double> downloadStatus() {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            return Map.copyOf(this.downloadStatus);
        }
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public void close() {
        try {
            this.downloadExecutor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }
}

