/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.FileReference;
import com.yahoo.jrt.DoubleArray;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FileDistributionRpcServer {
    private static final Logger log = Logger.getLogger(FileDistributionRpcServer.class.getName());
    private final Supervisor supervisor;
    private final FileDownloader downloader;
    private final ExecutorService rpcDownloadExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new DaemonThreadFactory("Rpc executor"));
    private static final int baseErrorCode = 65536;
    private static final int baseFileProviderErrorCode = 69632;
    private static final int fileReferenceDoesNotExists = 69632;
    private static final int fileReferenceRemoved = 69633;
    private static final int fileReferenceInternalError = 69634;

    public FileDistributionRpcServer(Supervisor supervisor, FileDownloader downloader) {
        this.supervisor = supervisor;
        this.downloader = downloader;
        this.declareFileDistributionMethods();
    }

    private void declareFileDistributionMethods() {
        this.supervisor.addMethod(new Method("waitFor", "s", "s", (Object)this, "getFile").methodDesc("get path to file reference").paramDesc(0, "file reference", "file reference").returnDesc(0, "path", "path to file"));
        this.supervisor.addMethod(new Method("filedistribution.getFile", "s", "s", (Object)this, "getFile").methodDesc("get path to file reference").paramDesc(0, "file reference", "file reference").returnDesc(0, "path", "path to file"));
        this.supervisor.addMethod(new Method("filedistribution.getActiveFileReferencesStatus", "", "SD", (Object)this, "getActiveFileReferencesStatus").methodDesc("download status for file references").returnDesc(0, "file references", "array of file references").returnDesc(1, "download status", "percentage downloaded of each file reference in above array"));
        this.supervisor.addMethod(new Method("filedistribution.setFileReferencesToDownload", "S", "i", (Object)this, "setFileReferencesToDownload").methodDesc("set which file references to download").paramDesc(0, "file references", "file reference to download").returnDesc(0, "ret", "0 if success, 1 otherwise"));
    }

    public final void getFile(Request req) {
        req.detach();
        this.rpcDownloadExecutor.execute(() -> this.downloadFile(req));
    }

    public final void getActiveFileReferencesStatus(Request req) {
        Map<FileReference, Double> downloadStatus = this.downloader.downloadStatus();
        String[] fileRefArray = new String[downloadStatus.keySet().size()];
        fileRefArray = downloadStatus.keySet().stream().map(FileReference::value).collect(Collectors.toList()).toArray(fileRefArray);
        double[] downloadStatusArray = new double[downloadStatus.values().size()];
        int i = 0;
        for (Double d : downloadStatus.values()) {
            downloadStatusArray[i++] = d;
        }
        req.returnValues().add((Value)new StringArray(fileRefArray));
        req.returnValues().add((Value)new DoubleArray(downloadStatusArray));
    }

    public final void setFileReferencesToDownload(Request req) {
        log.log((Level)LogLevel.DEBUG, () -> "Received method call '" + req.methodName() + "' with parameters : " + req.parameters());
        Arrays.stream(req.parameters().get(0).asStringArray()).map(FileReference::new).forEach(fileReference -> this.downloader.downloadIfNeeded(new FileReferenceDownload((FileReference)fileReference)));
        req.returnValues().add((Value)new Int32Value(0));
    }

    private void downloadFile(Request req) {
        FileReference fileReference = new FileReference(req.parameters().get(0).asString());
        log.log((Level)LogLevel.DEBUG, () -> "getFile() called for file reference '" + fileReference.value() + "'");
        Optional<File> pathToFile = this.downloader.getFile(fileReference);
        try {
            if (pathToFile.isPresent()) {
                req.returnValues().add((Value)new StringValue(pathToFile.get().getAbsolutePath()));
                log.log((Level)LogLevel.DEBUG, () -> "File reference '" + fileReference.value() + "' available at " + pathToFile.get());
            } else {
                log.log(LogLevel.INFO, "File reference '" + fileReference.value() + "' not found, returning error");
                req.setError(69632, "File reference '" + fileReference.value() + "' not found");
            }
        }
        catch (Throwable e) {
            log.log(LogLevel.WARNING, "File reference '" + fileReference.value() + "' got exception: " + e.getMessage());
            req.setError(69634, "File reference '" + fileReference.value() + "' removed");
        }
        req.returnRequest();
    }
}

