/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.yahoo.config.FileReference;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.filedistribution.FileReferenceDownloader;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDownloader {
    private static final Logger log = Logger.getLogger(FileDownloader.class.getName());
    private final File downloadDirectory;
    private final Duration timeout;
    private final FileReferenceDownloader fileReferenceDownloader;

    public FileDownloader(ConnectionPool connectionPool) {
        this(connectionPool, new File(Defaults.getDefaults().underVespaHome("var/db/vespa/filedistribution")), new File(Defaults.getDefaults().underVespaHome("var/db/vespa/filedistribution")), Duration.ofMinutes(15L));
    }

    FileDownloader(ConnectionPool connectionPool, File downloadDirectory, File tmpDirectory, Duration timeout) {
        this.downloadDirectory = downloadDirectory;
        this.timeout = timeout;
        this.fileReferenceDownloader = new FileReferenceDownloader(downloadDirectory, tmpDirectory, connectionPool, timeout);
    }

    public Optional<File> getFile(FileReference fileReference) {
        try {
            return this.getFutureFile(fileReference).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return Optional.empty();
        }
    }

    private Future<Optional<File>> getFutureFile(FileReference fileReference) {
        Objects.requireNonNull(fileReference, "file reference cannot be null");
        File directory = new File(this.downloadDirectory, fileReference.value());
        log.log((Level)LogLevel.DEBUG, () -> "Checking if there is a file in '" + directory.getAbsolutePath() + "' ");
        Optional<File> file = this.getFileFromFileSystem(fileReference, directory);
        if (file.isPresent()) {
            SettableFuture future = SettableFuture.create();
            future.set(file);
            return future;
        }
        log.log((Level)LogLevel.DEBUG, () -> "File reference '" + fileReference.value() + "' not found in " + directory.getAbsolutePath() + ", starting download");
        return this.queueForAsyncDownload(fileReference, this.timeout);
    }

    public void queueForAsyncDownload(List<FileReference> fileReferences) {
        fileReferences.forEach(fileReference -> {
            if (this.fileReferenceDownloader.isDownloading((FileReference)fileReference)) {
                log.log((Level)LogLevel.DEBUG, () -> "Already downloading '" + fileReference.value() + "'");
            } else {
                this.queueForAsyncDownload((FileReference)fileReference);
            }
        });
    }

    void receiveFile(FileReferenceData fileReferenceData) {
        this.fileReferenceDownloader.receiveFile(fileReferenceData);
    }

    double downloadStatus(FileReference fileReference) {
        return this.fileReferenceDownloader.downloadStatus(fileReference.value());
    }

    public Map<FileReference, Double> downloadStatus() {
        return this.fileReferenceDownloader.downloadStatus();
    }

    File downloadDirectory() {
        return this.downloadDirectory;
    }

    private Optional<File> getFileFromFileSystem(FileReference fileReference, File directory) {
        File[] files = directory.listFiles();
        if (directory.exists() && directory.isDirectory() && files != null && files.length > 0) {
            File file = files[0];
            if (!file.exists()) {
                throw new RuntimeException("File with reference '" + fileReference.value() + "' does not exist");
            }
            if (!file.canRead()) {
                throw new RuntimeException("File with reference '" + fileReference.value() + "'exists, but unable to read it");
            }
            this.fileReferenceDownloader.setDownloadStatus(fileReference, 1.0);
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private synchronized Future<Optional<File>> queueForAsyncDownload(FileReference fileReference, Duration timeout) {
        ListenableFuture<Optional<File>> inProgress = this.fileReferenceDownloader.addDownloadListener(fileReference, () -> this.getFile(fileReference));
        if (inProgress != null) {
            log.log((Level)LogLevel.DEBUG, () -> "Already downloading '" + fileReference.value() + "'");
            return inProgress;
        }
        Future<Optional<File>> future = this.queueForAsyncDownload(fileReference);
        log.log((Level)LogLevel.DEBUG, () -> "Queued '" + fileReference.value() + "' for download with timeout " + timeout);
        return future;
    }

    private Future<Optional<File>> queueForAsyncDownload(FileReference fileReference) {
        FileReferenceDownload fileReferenceDownload = new FileReferenceDownload(fileReference, (SettableFuture<Optional<File>>)SettableFuture.create());
        this.fileReferenceDownloader.addToDownloadQueue(fileReferenceDownload);
        return fileReferenceDownload.future();
    }

    public FileReferenceDownloader fileReferenceDownloader() {
        return this.fileReferenceDownloader;
    }
}

