/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;

public class LazyFileReferenceData
extends FileReferenceData {
    private final File file;
    private final ReadableByteChannel channel;
    private final StreamingXXHash64 hasher;

    public LazyFileReferenceData(FileReference fileReference, String filename, FileReferenceData.Type type, File file) throws IOException {
        super(fileReference, filename, type);
        this.file = file;
        this.channel = Files.newByteChannel(file.toPath(), new OpenOption[0]);
        this.hasher = XXHashFactory.fastestInstance().newStreamingHash64(0L);
    }

    @Override
    public int nextContent(ByteBuffer bb) {
        int read = 0;
        int pos = bb.position();
        try {
            read = this.channel.read(bb);
        }
        catch (IOException e) {
            return -1;
        }
        if (read > 0) {
            this.hasher.update(bb.array(), pos, read);
        }
        return read;
    }

    @Override
    public long xxhash() {
        return this.hasher.getValue();
    }

    @Override
    public long size() {
        try {
            return Files.size(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

