/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.filedistribution.fileacquirer;

import com.yahoo.filedistribution.fileacquirer.TimeoutException;
import java.util.concurrent.TimeUnit;

class Timer {
    private final long endTime;

    private long timeLeft() {
        return this.endTime - System.currentTimeMillis();
    }

    public Timer(long timeout, TimeUnit timeUnit) {
        this.endTime = System.currentTimeMillis() + timeUnit.toMillis(timeout);
    }

    public long timeLeft(TimeUnit timeUnit) {
        long remaining = timeUnit.convert(this.timeLeft(), TimeUnit.MILLISECONDS);
        if (remaining > 0L) {
            return remaining;
        }
        throw new TimeoutException("Timed out");
    }

    public boolean isTimeLeft() {
        return this.timeLeft() > 0L;
    }
}

