/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.filedistribution.fileacquirer;

import com.yahoo.config.FileReference;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.filedistribution.fileacquirer.FileReferenceDoesNotExistException;
import com.yahoo.filedistribution.fileacquirer.TimeoutException;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class MockFileAcquirer
implements FileAcquirer {
    public static FileAcquirer returnFile(final File file) {
        return new MockFileAcquirer(){

            @Override
            public File waitFor(FileReference fileReference, long timeout, TimeUnit timeUnit) throws InterruptedException {
                return file;
            }
        };
    }

    public static FileAcquirer returnFiles(final Map<String, File> files) {
        return new MockFileAcquirer(){

            @Override
            public File waitFor(FileReference fileReference, long timeout, TimeUnit timeUnit) throws InterruptedException {
                return (File)files.get(fileReference.value());
            }
        };
    }

    public static FileAcquirer throwTimeoutException() {
        return new MockFileAcquirer(){

            @Override
            public File waitFor(FileReference fileReference, long timeout, TimeUnit timeUnit) throws InterruptedException {
                throw new TimeoutException("Timed out");
            }
        };
    }

    public static FileAcquirer throwFileReferenceDoesNotExistException() {
        return new MockFileAcquirer(){

            @Override
            public File waitFor(FileReference fileReference, long timeout, TimeUnit timeUnit) throws InterruptedException {
                throw new FileReferenceDoesNotExistException(null);
            }
        };
    }

    @Override
    public void shutdown() {
    }
}

