/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.document.BucketId;
import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.documentapi.Parameters;
import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.messagebus.loadtypes.LoadType;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.text.Utf8;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class VisitorParameters
extends Parameters {
    private String documentSelection;
    private String bucketSpace = FixedBucketSpaces.defaultSpace();
    private String visitorLibrary = "DumpVisitor";
    private int maxPending = 32;
    private long timeoutMs = -1L;
    private long sessionTimeoutMs = -1L;
    private long fromTimestamp = 0L;
    private long toTimestamp = 0L;
    boolean visitRemoves = false;
    private String fieldSet = "[all]";
    boolean visitInconsistentBuckets = false;
    private ProgressToken resumeToken = null;
    private String resumeFileName = "";
    private String remoteDataHandler = null;
    private VisitorDataHandler localDataHandler;
    private VisitorControlHandler controlHandler;
    private Map<String, byte[]> libraryParameters = new TreeMap<String, byte[]>();
    private Route visitRoute = null;
    private float weight = 1.0f;
    private long maxFirstPassHits = -1L;
    private long maxTotalHits = -1L;
    private int visitorOrdering = 0;
    private int maxBucketsPerVisitor = 1;
    private boolean dynamicallyIncreaseMaxBucketsPerVisitor = false;
    private float dynamicMaxBucketsIncreaseFactor = 2.0f;
    private LoadType loadType = LoadType.DEFAULT;
    private DocumentProtocol.Priority priority = null;
    private int traceLevel = 0;
    private ThrottlePolicy throttlePolicy = null;
    private boolean skipBucketsOnFatalErrors = false;
    Set<BucketId> bucketsToVisit = null;

    public VisitorParameters(String documentSelection) {
        this.documentSelection = documentSelection;
    }

    public VisitorParameters(VisitorParameters params) {
        this.setDocumentSelection(params.getDocumentSelection());
        this.setBucketSpace(params.getBucketSpace());
        this.setVisitorLibrary(params.getVisitorLibrary());
        this.setMaxPending(params.getMaxPending());
        this.setTimeoutMs(params.getTimeoutMs());
        this.setFromTimestamp(params.getFromTimestamp());
        this.setToTimestamp(params.getToTimestamp());
        this.visitRemoves(params.visitRemoves());
        this.fieldSet(params.fieldSet());
        this.visitInconsistentBuckets(params.visitInconsistentBuckets());
        this.setLibraryParameters(params.getLibraryParameters());
        this.setRoute(params.getRoute());
        this.setResumeFileName(params.getResumeFileName());
        this.setResumeToken(params.getResumeToken());
        if (params.getRemoteDataHandler() != null) {
            this.setRemoteDataHandler(params.getRemoteDataHandler());
        } else {
            this.setLocalDataHandler(params.getLocalDataHandler());
        }
        this.setControlHandler(params.getControlHandler());
        this.setMaxFirstPassHits(params.getMaxFirstPassHits());
        this.setMaxTotalHits(params.getMaxTotalHits());
        this.setVisitorOrdering(params.getVisitorOrdering());
        this.setMaxBucketsPerVisitor(params.getMaxBucketsPerVisitor());
        this.setLoadType(params.getLoadType());
        this.setPriority(params.getPriority());
        this.setDynamicallyIncreaseMaxBucketsPerVisitor(params.getDynamicallyIncreaseMaxBucketsPerVisitor());
        this.setDynamicMaxBucketsIncreaseFactor(params.getDynamicMaxBucketsIncreaseFactor());
        this.setTraceLevel(params.getTraceLevel());
        this.skipBucketsOnFatalErrors(params.skipBucketsOnFatalErrors());
    }

    public String getDocumentSelection() {
        return this.documentSelection;
    }

    public String getBucketSpace() {
        return this.bucketSpace;
    }

    public String getVisitorLibrary() {
        return this.visitorLibrary;
    }

    public int getMaxPending() {
        return this.maxPending;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public long getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public long getFromTimestamp() {
        return this.fromTimestamp;
    }

    public long getToTimestamp() {
        return this.toTimestamp;
    }

    public boolean visitRemoves() {
        return this.visitRemoves;
    }

    public boolean getVisitRemoves() {
        return this.visitRemoves;
    }

    @Deprecated
    public boolean getVisitHeadersOnly() {
        return false;
    }

    public String fieldSet() {
        return this.fieldSet;
    }

    public String getFieldSet() {
        return this.fieldSet;
    }

    public boolean visitInconsistentBuckets() {
        return this.visitInconsistentBuckets;
    }

    public boolean getVisitInconsistentBuckets() {
        return this.visitInconsistentBuckets;
    }

    public Map<String, byte[]> getLibraryParameters() {
        return this.libraryParameters;
    }

    public ProgressToken getResumeToken() {
        return this.resumeToken;
    }

    public String getResumeFileName() {
        return this.resumeFileName;
    }

    public String getRemoteDataHandler() {
        return this.remoteDataHandler;
    }

    public VisitorDataHandler getLocalDataHandler() {
        return this.localDataHandler;
    }

    public VisitorControlHandler getControlHandler() {
        return this.controlHandler;
    }

    public boolean getDynamicallyIncreaseMaxBucketsPerVisitor() {
        return this.dynamicallyIncreaseMaxBucketsPerVisitor;
    }

    public float getDynamicMaxBucketsIncreaseFactor() {
        return this.dynamicMaxBucketsIncreaseFactor;
    }

    public DocumentProtocol.Priority getPriority() {
        if (this.priority != null) {
            return this.priority;
        }
        if (this.loadType != null) {
            return this.loadType.getPriority();
        }
        return DocumentProtocol.Priority.NORMAL_3;
    }

    public void setDocumentSelection(String selection) {
        this.documentSelection = selection;
    }

    public void setBucketSpace(String bucketSpace) {
        this.bucketSpace = bucketSpace;
    }

    public void setVisitorLibrary(String library) {
        this.visitorLibrary = library;
    }

    public void setMaxPending(int maxPending) {
        this.maxPending = maxPending;
    }

    public void setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void setSessionTimeoutMs(long timeoutMs) {
        this.sessionTimeoutMs = timeoutMs;
    }

    public void setFromTimestamp(long timestamp) {
        this.fromTimestamp = timestamp;
    }

    public void setToTimestamp(long timestamp) {
        this.toTimestamp = timestamp;
    }

    public void visitRemoves(boolean visitRemoves) {
        this.visitRemoves = visitRemoves;
    }

    public void setVisitRemoves(boolean visitRemoves) {
        this.visitRemoves = visitRemoves;
    }

    @Deprecated
    public void setVisitHeadersOnly(boolean headersOnly) {
    }

    public void fieldSet(String fieldSet) {
        this.fieldSet = fieldSet;
    }

    public void setFieldSet(String fieldSet) {
        this.fieldSet = fieldSet;
    }

    public void visitInconsistentBuckets(boolean visitInconsistentBuckets) {
        this.visitInconsistentBuckets = visitInconsistentBuckets;
    }

    public void setVisitInconsistentBuckets(boolean visitInconsistentBuckets) {
        this.visitInconsistentBuckets = visitInconsistentBuckets;
    }

    public void setLibraryParameter(String param, String value) {
        this.libraryParameters.put(param, Utf8.toBytes((String)value));
    }

    public void setLibraryParameter(String param, byte[] value) {
        this.libraryParameters.put(param, value);
    }

    public void setLibraryParameters(Map<String, byte[]> params) {
        this.libraryParameters = params;
    }

    public void setResumeToken(ProgressToken token) {
        this.resumeToken = token;
    }

    public void setResumeFileName(String fileName) {
        this.resumeFileName = fileName;
    }

    public void setRemoteDataHandler(String remoteDataHandler) {
        this.remoteDataHandler = remoteDataHandler;
        this.localDataHandler = null;
    }

    public void setLocalDataHandler(VisitorDataHandler localDataHandler) {
        this.localDataHandler = localDataHandler;
        this.remoteDataHandler = null;
    }

    public void setControlHandler(VisitorControlHandler controlHandler) {
        this.controlHandler = controlHandler;
    }

    public void setRoute(String route) {
        this.setRoute(Route.parse((String)route));
    }

    public void setRoute(Route route) {
        this.visitRoute = route;
    }

    public Route getRoute() {
        return this.visitRoute;
    }

    public void setMaxFirstPassHits(long max) {
        this.maxFirstPassHits = max;
    }

    public long getMaxFirstPassHits() {
        return this.maxFirstPassHits;
    }

    public void setMaxTotalHits(long max) {
        this.maxTotalHits = max;
    }

    public long getMaxTotalHits() {
        return this.maxTotalHits;
    }

    public Set<BucketId> getBucketsToVisit() {
        return this.bucketsToVisit;
    }

    public void setBucketsToVisit(Set<BucketId> buckets) {
        this.bucketsToVisit = buckets;
    }

    public int getVisitorOrdering() {
        return this.visitorOrdering;
    }

    public void setVisitorOrdering(int order) {
        this.visitorOrdering = order;
    }

    public int getMaxBucketsPerVisitor() {
        return this.maxBucketsPerVisitor;
    }

    public void setMaxBucketsPerVisitor(int max) {
        this.maxBucketsPerVisitor = max;
    }

    public void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void setPriority(DocumentProtocol.Priority priority) {
        this.priority = priority;
    }

    public ThrottlePolicy getThrottlePolicy() {
        return this.throttlePolicy;
    }

    public void setThrottlePolicy(ThrottlePolicy policy) {
        this.throttlePolicy = policy;
    }

    public void setLoadType(LoadType loadType) {
        this.loadType = loadType;
    }

    public LoadType getLoadType() {
        return this.loadType;
    }

    public boolean skipBucketsOnFatalErrors() {
        return this.skipBucketsOnFatalErrors;
    }

    public void skipBucketsOnFatalErrors(boolean skipBucketsOnFatalErrors) {
        this.skipBucketsOnFatalErrors = skipBucketsOnFatalErrors;
    }

    public void setDynamicallyIncreaseMaxBucketsPerVisitor(boolean dynamicallyIncreaseMaxBucketsPerVisitor) {
        this.dynamicallyIncreaseMaxBucketsPerVisitor = dynamicallyIncreaseMaxBucketsPerVisitor;
    }

    public void setDynamicMaxBucketsIncreaseFactor(float dynamicMaxBucketsIncreaseFactor) {
        this.dynamicMaxBucketsIncreaseFactor = dynamicMaxBucketsIncreaseFactor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("VisitorParameters(\n").append("  Document selection: ").append(this.documentSelection).append('\n').append("  Bucket space:       ").append(this.bucketSpace).append('\n').append("  Visitor library:    ").append(this.visitorLibrary).append('\n').append("  Max pending:        ").append(this.maxPending).append('\n').append("  Timeout (ms):       ").append(this.timeoutMs).append('\n').append("  Time period:        ").append(this.fromTimestamp).append(" - ").append(this.toTimestamp).append('\n');
        if (this.visitRemoves) {
            sb.append("  Visiting remove entries\n");
        }
        if (this.visitInconsistentBuckets) {
            sb.append("  Visiting inconsistent buckets\n");
        }
        if (this.libraryParameters.size() > 0) {
            sb.append("  Visitor library parameters:\n");
            for (Map.Entry<String, byte[]> e : this.libraryParameters.entrySet()) {
                sb.append("    ").append(e.getKey()).append(" : ");
                sb.append(Utf8.toString((byte[])e.getValue())).append('\n');
            }
        }
        sb.append("  Field set:          ").append(this.fieldSet).append('\n');
        sb.append("  Route:              ").append(this.visitRoute).append('\n');
        sb.append("  Weight:             ").append(this.weight).append('\n');
        sb.append("  Max firstpass hits: ").append(this.maxFirstPassHits).append('\n');
        sb.append("  Max total hits:     ").append(this.maxTotalHits).append('\n');
        sb.append("  Visitor ordering:   ").append(this.visitorOrdering).append('\n');
        sb.append("  Max buckets:        ").append(this.maxBucketsPerVisitor).append('\n');
        sb.append("  Priority:           ").append(this.getPriority().toString()).append('\n');
        if (this.dynamicallyIncreaseMaxBucketsPerVisitor) {
            sb.append("  Dynamically increasing max buckets per visitor\n");
            sb.append("  Increase factor:    ").append(this.dynamicMaxBucketsIncreaseFactor).append('\n');
        }
        sb.append(')');
        return sb.toString();
    }
}

