/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.VisitorControlSession;
import com.yahoo.vdslib.VisitorStatistics;
import java.time.Duration;

public class VisitorControlHandler {
    private VisitorControlSession session;
    private ProgressToken currentProgress;
    private boolean completed = false;
    private Result result;
    private VisitorStatistics currentStatistics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        VisitorControlHandler visitorControlHandler = this;
        synchronized (visitorControlHandler) {
            this.session = null;
            this.currentProgress = null;
            this.completed = false;
            this.result = null;
        }
    }

    public void onProgress(ProgressToken token) {
        this.currentProgress = token;
    }

    public void onVisitorError(String message) {
    }

    public void onVisitorStatistics(VisitorStatistics vs) {
        this.currentStatistics = vs;
    }

    public boolean hasVisitedAnyBuckets() {
        return this.currentStatistics != null && this.currentStatistics.getBucketsVisited() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDone(CompletionCode code, String message) {
        VisitorControlHandler visitorControlHandler = this;
        synchronized (visitorControlHandler) {
            this.completed = true;
            this.result = new Result();
            this.result.code = code;
            this.result.message = message;
            this.notifyAll();
        }
    }

    public void setSession(VisitorControlSession session) {
        this.session = session;
    }

    public ProgressToken getProgress() {
        return this.currentProgress;
    }

    public VisitorStatistics getVisitorStatistics() {
        return this.currentStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        VisitorControlHandler visitorControlHandler = this;
        synchronized (visitorControlHandler) {
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilDone(Duration timeout) throws InterruptedException {
        VisitorControlHandler visitorControlHandler = this;
        synchronized (visitorControlHandler) {
            if (this.completed) {
                return true;
            }
            if (timeout.isZero()) {
                while (!this.completed) {
                    this.wait();
                }
            } else {
                this.wait(timeout.toMillis());
            }
            return this.completed;
        }
    }

    public boolean waitUntilDone(long timeoutMs) throws InterruptedException {
        return this.waitUntilDone(Duration.ofMillis(timeoutMs));
    }

    public void waitUntilDone() throws InterruptedException {
        boolean done = this.waitUntilDone(Duration.ZERO);
        assert (done) : "Infinite waitUntilDone timeout should always complete";
    }

    public void abort() {
        this.session.abort();
    }

    public Result getResult() {
        return this.result;
    }

    public class Result {
        public CompletionCode code;
        public String message;

        public String toString() {
            switch (this.code) {
                case SUCCESS: {
                    return "OK: " + this.message;
                }
                case ABORTED: {
                    return "ABORTED: " + this.message;
                }
                case FAILURE: {
                    return "FAILURE: " + this.message;
                }
                case TIMEOUT: {
                    return "TIMEOUT: " + this.message;
                }
            }
            return "Unknown error";
        }

        public CompletionCode getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum CompletionCode {
        SUCCESS,
        ABORTED,
        FAILURE,
        TIMEOUT;

    }
}

