/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.document.BucketId;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentDeserializerFactory;
import com.yahoo.document.serialization.DocumentSerializer;
import com.yahoo.document.serialization.DocumentSerializerFactory;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.log.LogLevel;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProgressToken {
    private static final Logger log = Logger.getLogger(ProgressToken.class.getName());
    public static final BucketId NULL_BUCKET = new BucketId();
    public static final BucketId FINISHED_BUCKET = new BucketId(Integer.MAX_VALUE);
    private int distributionBits = 16;
    private TreeMap<BucketKeyWrapper, BucketEntry> buckets = new TreeMap();
    private long activeBucketCount = 0L;
    private long pendingBucketCount = 0L;
    private long finishedBucketCount = 0L;
    private long totalBucketCount = 0L;
    private TreeMap<BucketId, BucketId> failedBuckets = new TreeMap();
    private String firstErrorMsg;
    private long bucketCursor = 0L;
    private boolean inconsistentState = false;

    public ProgressToken() {
    }

    public ProgressToken(int distributionBits) {
        this.distributionBits = distributionBits;
    }

    public ProgressToken(String serialized) {
        String[] lines = serialized.split("\\n");
        if (lines.length < 5) {
            throw new IllegalArgumentException("Progress file is malformed or a deprecated version");
        }
        String header = lines[0];
        if (!header.startsWith("VDS bucket progress file")) {
            throw new IllegalArgumentException("File does not appear to be a valid VDS progress file; expected first line to start with 'VDS bucket progress file'");
        }
        this.distributionBits = Integer.parseInt(lines[1]);
        this.bucketCursor = Long.parseLong(lines[2]);
        this.finishedBucketCount = Long.parseLong(lines[3]);
        this.totalBucketCount = Long.parseLong(lines[4]);
        if (this.totalBucketCount == this.finishedBucketCount) {
            return;
        }
        for (int i = 5; i < lines.length; ++i) {
            String[] buckets = lines[i].split(":");
            if (buckets.length != 2) {
                throw new IllegalArgumentException("Bucket progress file contained malformed line");
            }
            BucketId superId = new BucketId("BucketId(0x" + buckets[0] + ")");
            BucketId subId = "0".equals(buckets[1]) ? new BucketId() : new BucketId("BucketId(0x" + buckets[1] + ")");
            this.addBucket(superId, subId, BucketState.BUCKET_PENDING);
        }
    }

    public ProgressToken(byte[] serialized) {
        DocumentDeserializer in = DocumentDeserializerFactory.create42(null, (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])serialized));
        this.distributionBits = in.getInt(null);
        this.bucketCursor = in.getLong(null);
        this.finishedBucketCount = in.getLong(null);
        this.totalBucketCount = in.getLong(null);
        int progressCount = in.getInt(null);
        for (int i = 0; i < progressCount; ++i) {
            long key = in.getLong(null);
            long value = in.getLong(null);
            this.addBucket(new BucketId(key), new BucketId(value), BucketState.BUCKET_PENDING);
        }
    }

    public byte[] serialize() {
        DocumentSerializer out = DocumentSerializerFactory.create42((GrowableByteBuffer)new GrowableByteBuffer());
        out.putInt(null, this.distributionBits);
        out.putLong(null, this.bucketCursor);
        out.putLong(null, this.finishedBucketCount);
        out.putLong(null, this.totalBucketCount);
        out.putInt(null, this.buckets.size());
        for (Map.Entry<BucketKeyWrapper, BucketEntry> entry : this.buckets.entrySet()) {
            out.putLong(null, ProgressToken.keyToBucketId(entry.getKey().getKey()));
            out.putLong(null, entry.getValue().getProgress().getRawId());
        }
        byte[] ret = new byte[out.getBuf().position()];
        out.getBuf().rewind();
        out.getBuf().get(ret);
        return ret;
    }

    public void addFailedBucket(BucketId superbucket, BucketId progress, String errorMsg) {
        BucketId existing = this.failedBuckets.put(superbucket, progress);
        if (existing != null) {
            throw new IllegalStateException("Attempting to add a superbucket to failed buckets that has already been added: " + superbucket + ":" + progress);
        }
        if (this.firstErrorMsg == null) {
            this.firstErrorMsg = errorMsg;
        }
    }

    public Map<BucketId, BucketId> getFailedBuckets() {
        return Collections.unmodifiableMap(this.failedBuckets);
    }

    protected void updateProgress(BucketId superbucket, BucketId progress) {
        BucketKeyWrapper superKey;
        BucketEntry entry;
        if (!(progress.equals((Object)NULL_BUCKET) || progress.equals((Object)FINISHED_BUCKET) || superbucket.contains(progress) || progress.contains(superbucket) || !log.isLoggable((Level)LogLevel.DEBUG))) {
            log.log((Level)LogLevel.DEBUG, "updateProgress called with non-contained bucket pair " + superbucket + ":" + progress + ", but allowing anyway");
        }
        if ((entry = this.buckets.get(superKey = ProgressToken.bucketToKeyWrapper(superbucket))) == null) {
            throw new IllegalArgumentException("updateProgress with unknown superbucket " + superbucket + ":" + progress);
        }
        if (!progress.equals((Object)FINISHED_BUCKET)) {
            if (entry.getState() != BucketState.BUCKET_ACTIVE) {
                if (log.isLoggable((Level)LogLevel.DEBUG)) {
                    log.log((Level)LogLevel.DEBUG, "updateProgress called with sub-bucket that was not marked as active " + superbucket + ":" + progress);
                }
            } else {
                assert (this.activeBucketCount > 0L);
                --this.activeBucketCount;
                ++this.pendingBucketCount;
            }
            entry.setState(BucketState.BUCKET_PENDING);
            entry.setProgress(progress);
        } else {
            ++this.finishedBucketCount;
            if (entry.getState() == BucketState.BUCKET_PENDING) {
                assert (this.pendingBucketCount > 0L);
                --this.pendingBucketCount;
            } else {
                assert (this.activeBucketCount > 0L);
                --this.activeBucketCount;
            }
            this.buckets.remove(superKey);
        }
    }

    protected void addBucket(BucketId superbucket, BucketId progress, BucketState state) {
        if (progress.equals((Object)FINISHED_BUCKET)) {
            if (log.isLoggable((Level)LogLevel.DEBUG)) {
                log.log((Level)LogLevel.DEBUG, "Trying to add already finished superbucket " + superbucket + "; ignoring it");
            }
            return;
        }
        if (log.isLoggable((Level)LogLevel.SPAM)) {
            log.log((Level)LogLevel.SPAM, "Adding bucket pair " + superbucket + ":" + progress + " with state " + (Object)((Object)state));
        }
        BucketEntry entry = new BucketEntry(progress, state);
        BucketEntry existing = this.buckets.put(ProgressToken.bucketToKeyWrapper(superbucket), entry);
        if (existing != null) {
            throw new IllegalStateException("Attempting to add a superbucket that has already been added: " + superbucket + ":" + progress);
        }
        if (state == BucketState.BUCKET_PENDING) {
            ++this.pendingBucketCount;
        } else {
            ++this.activeBucketCount;
        }
    }

    public static long makeNthBucketKey(long n, int distributionBits) {
        return n << 64 - distributionBits | (long)distributionBits;
    }

    public int getDistributionBitCount() {
        return this.distributionBits;
    }

    protected void setDistributionBitCount(int distributionBits) {
        this.distributionBits = distributionBits;
    }

    public long getActiveBucketCount() {
        return this.activeBucketCount;
    }

    public long getBucketCursor() {
        return this.bucketCursor;
    }

    protected void setBucketCursor(long bucketCursor) {
        this.bucketCursor = bucketCursor;
    }

    public long getFinishedBucketCount() {
        return this.finishedBucketCount;
    }

    protected void setFinishedBucketCount(long finishedBucketCount) {
        this.finishedBucketCount = finishedBucketCount;
    }

    public long getTotalBucketCount() {
        return this.totalBucketCount;
    }

    protected void setTotalBucketCount(long totalBucketCount) {
        this.totalBucketCount = totalBucketCount;
    }

    public long getPendingBucketCount() {
        return this.pendingBucketCount;
    }

    public boolean hasPending() {
        return this.pendingBucketCount > 0L;
    }

    public boolean hasActive() {
        return this.activeBucketCount > 0L;
    }

    public boolean isFinished() {
        return this.finishedBucketCount == this.totalBucketCount;
    }

    public boolean isEmpty() {
        return this.buckets.isEmpty();
    }

    public String getFirstErrorMsg() {
        return this.firstErrorMsg;
    }

    public boolean containsFailedBuckets() {
        return !this.failedBuckets.isEmpty();
    }

    public boolean isInconsistentState() {
        return this.inconsistentState;
    }

    public void setInconsistentState(boolean inconsistentState) {
        this.inconsistentState = inconsistentState;
    }

    protected TreeMap<BucketKeyWrapper, BucketEntry> getBuckets() {
        return this.buckets;
    }

    protected void setActiveBucketCount(long activeBucketCount) {
        this.activeBucketCount = activeBucketCount;
    }

    protected void setPendingBucketCount(long pendingBucketCount) {
        this.pendingBucketCount = pendingBucketCount;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VDS bucket progress file (");
        sb.append(this.percentFinished());
        sb.append("% completed)\n");
        sb.append(this.distributionBits);
        sb.append('\n');
        sb.append(this.bucketCursor);
        sb.append('\n');
        long doneBucketCount = Math.max(0L, this.finishedBucketCount - (long)this.failedBuckets.size());
        sb.append(doneBucketCount);
        sb.append('\n');
        sb.append(this.totalBucketCount);
        sb.append('\n');
        for (Map.Entry<BucketKeyWrapper, BucketEntry> entry : this.buckets.entrySet()) {
            sb.append(Long.toHexString(ProgressToken.keyToBucketId(entry.getKey().getKey())));
            sb.append(':');
            sb.append(Long.toHexString(entry.getValue().getProgress().getRawId()));
            sb.append('\n');
        }
        for (Map.Entry<BucketKeyWrapper, BucketEntry> entry : this.failedBuckets.entrySet()) {
            sb.append(Long.toHexString(((BucketId)entry.getKey()).getRawId()));
            sb.append(':');
            sb.append(Long.toHexString(((BucketId)entry.getValue()).getRawId()));
            sb.append('\n');
        }
        return sb.toString();
    }

    public synchronized double percentFinished() {
        long superTotal = this.totalBucketCount;
        long superFinished = this.finishedBucketCount;
        if (superTotal == 0L || superTotal == superFinished) {
            return 100.0;
        }
        double superDelta = 100.0 / (double)superTotal;
        double cumulativeSubProgress = 0.0;
        for (Map.Entry<BucketKeyWrapper, BucketEntry> entry : this.buckets.entrySet()) {
            BucketId superbucket = new BucketId(ProgressToken.keyToBucketId(entry.getKey().getKey()));
            BucketId progress = entry.getValue().getProgress();
            if (progress.getId() == 0L || !superbucket.contains(progress)) continue;
            cumulativeSubProgress += superDelta * this.progressFraction(superbucket, progress);
        }
        return (double)superFinished / (double)superTotal * 100.0 + cumulativeSubProgress;
    }

    public static long bucketToKey(long id) {
        long retVal = Long.reverse(id);
        long usedCountLSB = id >>> 58;
        retVal >>>= 6;
        retVal <<= 6;
        return retVal |= usedCountLSB;
    }

    private static BucketKeyWrapper bucketToKeyWrapper(BucketId bucket) {
        return new BucketKeyWrapper(ProgressToken.bucketToKey(bucket.getId()));
    }

    public static long keyToBucketId(long key) {
        long retVal = Long.reverse(key);
        long usedCountMSB = key << 58;
        retVal <<= 6;
        retVal >>>= 6;
        return retVal |= usedCountMSB;
    }

    public synchronized double progressFraction(BucketId superbucket, BucketId progress) {
        long revBits = ProgressToken.bucketToKey(progress.getId());
        int superUsed = superbucket.getUsedBits();
        int progressUsed = progress.getUsedBits();
        if (progressUsed == 0 || progressUsed < superUsed) {
            return 0.0;
        }
        int splitCount = progressUsed - superUsed;
        if (splitCount == 0) {
            return 1.0;
        }
        revBits <<= superUsed;
        return (double)((revBits >>>= 64 - splitCount) + 1L) / (double)(1L << splitCount);
    }

    protected synchronized boolean isBucketFinished(BucketId bucket) {
        if (this.inconsistentState) {
            return false;
        }
        BucketId superbucket = new BucketId(this.distributionBits, bucket.getId());
        long reverseId = Long.reverse(superbucket.getId()) >>> 64 - this.distributionBits;
        if (reverseId >= this.bucketCursor) {
            return false;
        }
        BucketEntry entry = this.buckets.get(ProgressToken.bucketToKeyWrapper(superbucket));
        if (entry == null) {
            return true;
        }
        long bucketKey = ProgressToken.bucketToKey(bucket.getId());
        long progressKey = ProgressToken.bucketToKey(entry.getProgress().getId());
        return progressKey > bucketKey;
    }

    protected void splitPendingBucket(BucketId bucket) {
        BucketKeyWrapper bucketKey = ProgressToken.bucketToKeyWrapper(bucket);
        BucketEntry entry = this.buckets.get(bucketKey);
        if (entry == null) {
            throw new IllegalArgumentException("Attempting to split unknown bucket: " + bucket);
        }
        if (entry.getState() != BucketState.BUCKET_PENDING) {
            throw new IllegalArgumentException("Attempting to split non-pending bucket: " + bucket);
        }
        int splitDistBits = bucket.getUsedBits() + 1;
        BucketId splitLeft = new BucketId(splitDistBits, bucket.getId());
        BucketId splitRight = new BucketId(splitDistBits, bucket.getId() | 1L << bucket.getUsedBits());
        this.addBucket(splitLeft, entry.getProgress(), BucketState.BUCKET_PENDING);
        this.addBucket(splitRight, entry.getProgress(), BucketState.BUCKET_PENDING);
        this.buckets.remove(bucketKey);
        --this.pendingBucketCount;
    }

    protected void mergePendingBucket(BucketId bucket) {
        BucketKeyWrapper bucketKey = ProgressToken.bucketToKeyWrapper(bucket);
        BucketEntry entry = this.buckets.get(bucketKey);
        if (entry == null) {
            throw new IllegalArgumentException("Attempting to join unknown bucket: " + bucket);
        }
        if (entry.getState() != BucketState.BUCKET_PENDING) {
            throw new IllegalArgumentException("Attempting to join non-pending bucket: " + bucket);
        }
        int usedBits = bucket.getUsedBits();
        if ((bucket.getId() & 1L << usedBits - 1) == 0L) {
            BucketId rightCheck = new BucketId(usedBits, bucket.getId() | 1L << usedBits - 1);
            BucketEntry rightSibling = this.buckets.get(ProgressToken.bucketToKeyWrapper(rightCheck));
            if (rightSibling != null) {
                assert (rightSibling.getState() == BucketState.BUCKET_PENDING);
                if (log.isLoggable((Level)LogLevel.SPAM)) {
                    log.log((Level)LogLevel.SPAM, "Merging " + bucket + " with rhs " + rightCheck);
                }
                if (rightSibling.getProgress().getUsedBits() != 0 && log.isLoggable((Level)LogLevel.DEBUG)) {
                    log.log((Level)LogLevel.DEBUG, "Bucket progress for " + rightCheck + " will be lost due to merging; potential for duplicates in result-set");
                }
                this.buckets.remove(ProgressToken.bucketToKeyWrapper(rightCheck));
                --this.pendingBucketCount;
            }
        } else {
            BucketId leftSanityCheck = new BucketId(usedBits, bucket.getId() & (1L << usedBits - 1 ^ 0xFFFFFFFFFFFFFFFFL));
            BucketEntry leftSibling = this.buckets.get(ProgressToken.bucketToKeyWrapper(leftSanityCheck));
            assert (leftSibling == null) : "bucket merge sanity checking failed";
        }
        BucketId newMerged = new BucketId(usedBits - 1, bucket.getId());
        this.addBucket(newMerged, entry.getProgress(), BucketState.BUCKET_PENDING);
        this.buckets.remove(bucketKey);
        --this.pendingBucketCount;
        assert (this.pendingBucketCount > 0L);
    }

    protected void setAllBucketsToState(BucketState state) {
        for (Map.Entry<BucketKeyWrapper, BucketEntry> entry : this.buckets.entrySet()) {
            entry.getValue().setState(state);
        }
    }

    protected void clearAllBuckets() {
        this.buckets.clear();
        this.pendingBucketCount = 0L;
        this.activeBucketCount = 0L;
    }

    public static class BucketKeyWrapper
    implements Comparable<BucketKeyWrapper> {
        private long key;

        public BucketKeyWrapper(long key) {
            this.key = key;
        }

        @Override
        public int compareTo(BucketKeyWrapper other) {
            if ((this.key & Long.MIN_VALUE) != (other.key & Long.MIN_VALUE)) {
                return this.key >>> 63 > other.key >>> 63 ? 1 : -1;
            }
            if ((this.key & Long.MAX_VALUE) < (other.key & Long.MAX_VALUE)) {
                return -1;
            }
            if ((this.key & Long.MAX_VALUE) > (other.key & Long.MAX_VALUE)) {
                return 1;
            }
            return 0;
        }

        public long getKey() {
            return this.key;
        }

        public BucketId toBucketId() {
            return new BucketId(ProgressToken.keyToBucketId(this.key));
        }

        public String toString() {
            return Long.toHexString(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof BucketKeyWrapper)) {
                return false;
            }
            return this.key == ((BucketKeyWrapper)o).key;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32);
        }
    }

    public static class BucketEntry {
        private BucketId progress;
        private BucketState state;

        private BucketEntry(BucketId progress, BucketState state) {
            this.progress = progress;
            this.state = state;
        }

        public BucketId getProgress() {
            return this.progress;
        }

        public void setProgress(BucketId progress) {
            this.progress = progress;
        }

        public BucketState getState() {
            return this.state;
        }

        public void setState(BucketState state) {
            this.state = state;
        }
    }

    public static enum BucketState {
        BUCKET_PENDING,
        BUCKET_ACTIVE;

    }
}

