/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.BucketId;
import com.yahoo.document.BucketIdFactory;
import com.yahoo.document.DocumentId;
import com.yahoo.documentapi.messagebus.protocol.BatchDocumentUpdateMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.documentapi.messagebus.protocol.GetBucketStateMessage;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.RoutingNodeIterator;
import com.yahoo.vdslib.BucketDistribution;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SearchColumnPolicy
implements DocumentProtocolRoutingPolicy {
    private static Logger log = Logger.getLogger(SearchColumnPolicy.class.getName());
    private BucketIdFactory factory = new BucketIdFactory();
    private Map<Integer, BucketDistribution> distributions = new HashMap<Integer, BucketDistribution>();
    private int maxOOS = 0;
    public static final int DEFAULT_NUM_BUCKET_BITS = 16;

    public SearchColumnPolicy(String param) {
        if (param != null && param.length() > 0) {
            try {
                this.maxOOS = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                log.log(LogLevel.WARNING, "Parameter '" + param + "' could not be parsed as an integer.", e);
            }
            if (this.maxOOS < 0) {
                log.log(LogLevel.WARNING, "Ignoring a request to set the maximum number of OOS replies to " + this.maxOOS + " because it makes no sense. This routing policy will not allow any recipient to be out of service.");
            }
        }
    }

    public void select(RoutingContext context) {
        List recipients = context.getMatchedRecipients();
        if (recipients == null || recipients.size() == 0) {
            return;
        }
        DocumentId id = null;
        BucketId bucketId = null;
        Message msg = context.getMessage();
        switch (msg.getType()) {
            case 100004: {
                id = ((PutDocumentMessage)msg).getDocumentPut().getDocument().getId();
                break;
            }
            case 100003: {
                id = ((GetDocumentMessage)msg).getDocumentId();
                break;
            }
            case 100005: {
                id = ((RemoveDocumentMessage)msg).getDocumentId();
                break;
            }
            case 100006: {
                id = ((UpdateDocumentMessage)msg).getDocumentUpdate().getId();
                break;
            }
            case 100026: {
                bucketId = ((BatchDocumentUpdateMessage)msg).getBucketId();
                break;
            }
            case 100018: {
                bucketId = ((GetBucketStateMessage)msg).getBucketId();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Message type '" + msg.getType() + "' not supported.");
            }
        }
        if (bucketId == null && id != null) {
            bucketId = this.factory.getBucketId(id);
        }
        int recipient = this.getRecipient(bucketId, recipients.size());
        context.addChild((Route)recipients.get(recipient));
        context.setSelectOnRetry(true);
        if (this.maxOOS > 0) {
            context.addConsumableError(200004);
        }
    }

    public void merge(RoutingContext context) {
        if (this.maxOOS > 0) {
            if (context.getNumChildren() > 1) {
                HashSet<Integer> oosReplies = new HashSet<Integer>();
                int idx = 0;
                RoutingNodeIterator it = context.getChildIterator();
                while (it.isValid()) {
                    Reply ref = it.getReplyRef();
                    if (ref.hasErrors() && DocumentProtocol.hasOnlyErrorsOfType(ref, 200004)) {
                        oosReplies.add(idx);
                    }
                    ++idx;
                    it.next();
                }
                if (oosReplies.size() <= this.maxOOS) {
                    DocumentProtocol.merge(context, oosReplies);
                    return;
                }
            } else {
                Reply ref = context.getChildIterator().getReplyRef();
                if (ref.hasErrors() && DocumentProtocol.hasOnlyErrorsOfType(ref, 200004)) {
                    context.setReply((Reply)new EmptyReply());
                    return;
                }
            }
        }
        DocumentProtocol.merge(context);
    }

    private synchronized int getRecipient(BucketId bucketId, int numRecipients) {
        BucketDistribution distribution = this.distributions.get(numRecipients);
        if (distribution == null) {
            distribution = new BucketDistribution(1, 16);
            distribution.setNumColumns(numRecipients);
            this.distributions.put(numRecipients, distribution);
        }
        return distribution.getColumn(bucketId);
    }

    public void destroy() {
    }

    @Override
    public MetricSet getMetrics() {
        return null;
    }
}

