/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.RoutingNodeIterator;
import java.util.HashSet;
import java.util.logging.Logger;

public class SearchRowPolicy
implements DocumentProtocolRoutingPolicy {
    private static Logger log = Logger.getLogger(SearchRowPolicy.class.getName());
    private int minOk = 0;

    public SearchRowPolicy(String param) {
        if (param != null && param.length() > 0) {
            try {
                this.minOk = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                log.log(LogLevel.WARNING, "Parameter '" + param + "' could not be parsed as an integer.", e);
            }
            if (this.minOk <= 0) {
                log.log(LogLevel.WARNING, "Ignoring a request to set the minimum number of OK replies to " + this.minOk + " because it makes no sense. This routing policy will not allow any recipient to be out of service.");
            }
        }
    }

    public void select(RoutingContext context) {
        context.addChildren(context.getMatchedRecipients());
        context.setSelectOnRetry(false);
        if (this.minOk > 0) {
            context.addConsumableError(200004);
        }
    }

    public void merge(RoutingContext context) {
        if (this.minOk > 0) {
            HashSet<Integer> oosReplies = new HashSet<Integer>();
            int idx = 0;
            RoutingNodeIterator it = context.getChildIterator();
            while (it.isValid()) {
                Reply ref = it.getReplyRef();
                if (ref.hasErrors() && DocumentProtocol.hasOnlyErrorsOfType(ref, 200004)) {
                    oosReplies.add(idx);
                }
                ++idx;
                it.next();
            }
            if (context.getNumChildren() - oosReplies.size() >= this.minOk) {
                DocumentProtocol.merge(context, oosReplies);
                return;
            }
        }
        DocumentProtocol.merge(context);
    }

    public void destroy() {
    }

    @Override
    public MetricSet getMetrics() {
        return null;
    }
}

