/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.collections.CollectionComparator;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public final class Array<T extends FieldValue>
extends CollectionFieldValue<T>
implements List<T> {
    private List<T> values;

    public Array(DataType type) {
        this(type, 1);
    }

    public Array(DataType type, int initialCapacity) {
        super((ArrayDataType)type);
        this.values = new ArrayList<T>(initialCapacity);
    }

    public Array(DataType type, List<T> values) {
        this(type);
        for (FieldValue v : values) {
            if (((ArrayDataType)type).getNestedType().isValueCompatible(v)) continue;
            throw new IllegalArgumentException("FieldValue " + String.valueOf(v) + " is not compatible with " + String.valueOf(type) + ".");
        }
        this.values.addAll(values);
    }

    @Override
    public ArrayDataType getDataType() {
        return (ArrayDataType)super.getDataType();
    }

    @Override
    public Iterator<T> fieldValueIterator() {
        return this.values.iterator();
    }

    @Override
    public Array<T> clone() {
        Array array = (Array)super.clone();
        array.values = new ArrayList<T>(this.values.size());
        for (FieldValue fval : this.values) {
            array.values.add(fval.clone());
        }
        return array;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public void assign(Object o) {
        if (!this.checkAssign(o)) {
            return;
        }
        if (o instanceof Array) {
            if (o == this) {
                return;
            }
            Array a = (Array)o;
            this.values.clear();
            this.addAll((Collection<? extends T>)a.values);
        } else if (o instanceof List) {
            this.values = new ListWrapper<T>((List)o);
        } else {
            throw new IllegalArgumentException("Class " + String.valueOf(o.getClass()) + " not applicable to an " + String.valueOf(this.getClass()) + " instance.");
        }
    }

    @Override
    public Object getWrappedValue() {
        if (this.values instanceof ListWrapper) {
            return ((ListWrapper)this.values).myvalues;
        }
        ArrayList<Object> tmpWrappedList = new ArrayList<Object>();
        for (FieldValue value : this.values) {
            tmpWrappedList.add(value.getWrappedValue());
        }
        return tmpWrappedList;
    }

    public List<T> getValues() {
        return this.values;
    }

    public FieldValue getFieldValue(int index) {
        return (FieldValue)this.values.get(index);
    }

    @Override
    @Deprecated
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printArrayXml(this, xml);
    }

    public String toString() {
        return this.values.toString();
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        for (FieldValue val : this.values) {
            hashCode ^= val.hashCode();
        }
        return hashCode;
    }

    private boolean equalsWithListWrapper(List<? extends FieldValue> a, ListWrapper<? extends FieldValue> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (b.myvalues.get(i).equals(a.get(i).getWrappedValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Array)) {
            return false;
        }
        Array a = (Array)o;
        if (!super.equals(o)) {
            return false;
        }
        if (this.values.size() != a.values.size()) {
            return false;
        }
        if (this.values instanceof ListWrapper && !(a.values instanceof ListWrapper)) {
            return this.equalsWithListWrapper(a.values, (ListWrapper)this.values);
        }
        if (a.values instanceof ListWrapper && !(this.values instanceof ListWrapper)) {
            return this.equalsWithListWrapper(this.values, (ListWrapper)a.values);
        }
        return this.values.equals(a.values);
    }

    @Override
    public void add(int index, T o) {
        this.verifyElementCompatibility(o);
        this.values.add(index, o);
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public boolean add(T o) {
        this.verifyElementCompatibility(o);
        return this.values.add(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.values.contains(o);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty(this.values);
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }

    @Override
    public boolean removeValue(FieldValue o) {
        return super.removeValue(o, this.values);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (FieldValue t : c) {
            this.verifyElementCompatibility(t);
        }
        return this.values.addAll(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.values.containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.values.toArray(a);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        for (FieldValue t : c) {
            this.verifyElementCompatibility(t);
        }
        return this.values.addAll(index, c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.values.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.values.removeAll(c);
    }

    @Override
    public T get(int index) {
        return (T)((FieldValue)this.values.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.values.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.values.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.values.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.values.listIterator(index);
    }

    @Override
    public T remove(int index) {
        return (T)((FieldValue)this.values.remove(index));
    }

    @Override
    public T set(int index, T o) {
        this.verifyElementCompatibility(o);
        FieldValue fval = (FieldValue)this.values.set(index, o);
        return (T)fval;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.values.subList(fromIndex, toIndex);
    }

    FieldPathIteratorHandler.ModificationStatus iterateSubset(int startPos, int endPos, FieldPath fieldPath, String variable, int nextPos, FieldPathIteratorHandler handler) {
        FieldPathIteratorHandler.ModificationStatus retVal = FieldPathIteratorHandler.ModificationStatus.NOT_MODIFIED;
        LinkedList<Integer> indicesToRemove = new LinkedList<Integer>();
        for (int i = startPos; i <= endPos && i < this.values.size(); ++i) {
            FieldValue fv;
            FieldPathIteratorHandler.ModificationStatus status;
            if (variable != null) {
                handler.getVariables().put(variable, new FieldPathIteratorHandler.IndexValue(i));
            }
            if ((status = (fv = (FieldValue)this.values.get(i)).iterateNested(fieldPath, nextPos, handler)) == FieldPathIteratorHandler.ModificationStatus.REMOVED) {
                indicesToRemove.addFirst(i);
                retVal = FieldPathIteratorHandler.ModificationStatus.MODIFIED;
                continue;
            }
            if (status != FieldPathIteratorHandler.ModificationStatus.MODIFIED) continue;
            retVal = status;
        }
        if (variable != null) {
            handler.getVariables().remove(variable);
        }
        for (Integer idx : indicesToRemove) {
            this.values.remove(idx);
        }
        return retVal;
    }

    @Override
    FieldPathIteratorHandler.ModificationStatus iterateNested(FieldPath fieldPath, int pos, FieldPathIteratorHandler handler) {
        if (pos < fieldPath.size()) {
            switch (fieldPath.get(pos).getType()) {
                case ARRAY_INDEX: {
                    int elemIndex = fieldPath.get(pos).getLookupIndex();
                    return this.iterateSubset(elemIndex, elemIndex, fieldPath, null, pos + 1, handler);
                }
                case VARIABLE: {
                    FieldPathIteratorHandler.IndexValue val = (FieldPathIteratorHandler.IndexValue)handler.getVariables().get(fieldPath.get(pos).getVariableName());
                    if (val != null) {
                        int idx = val.getIndex();
                        if (idx == -1) {
                            throw new IllegalArgumentException("Mismatch between variables - trying to iterate through map and array with the same variable.");
                        }
                        if (idx < this.values.size()) {
                            return this.iterateSubset(idx, idx, fieldPath, null, pos + 1, handler);
                        }
                        return FieldPathIteratorHandler.ModificationStatus.NOT_MODIFIED;
                    }
                    return this.iterateSubset(0, this.values.size() - 1, fieldPath, fieldPath.get(pos).getVariableName(), pos + 1, handler);
                }
            }
            return this.iterateSubset(0, this.values.size() - 1, fieldPath, null, pos, handler);
        }
        FieldPathIteratorHandler.ModificationStatus status = handler.modify(this);
        if (status == FieldPathIteratorHandler.ModificationStatus.REMOVED) {
            return status;
        }
        if (handler.onComplex(this) && this.iterateSubset(0, this.values.size() - 1, fieldPath, null, pos, handler) != FieldPathIteratorHandler.ModificationStatus.NOT_MODIFIED) {
            status = FieldPathIteratorHandler.ModificationStatus.MODIFIED;
        }
        return status;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        Array otherValue = (Array)fieldValue;
        return CollectionComparator.compare(this.values, otherValue.values);
    }

    class ListWrapper<E>
    implements List<E>,
    RandomAccess {
        private final List myvalues;

        private Object unwrap(Object o) {
            return o instanceof FieldValue ? ((FieldValue)o).getWrappedValue() : o;
        }

        public ListWrapper(List wrapped) {
            this.myvalues = wrapped;
        }

        @Override
        public int size() {
            return this.myvalues.size();
        }

        @Override
        public boolean isEmpty() {
            return this.myvalues.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.myvalues.contains(this.unwrap(o));
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.myvalues.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Class<?> componentType = a.getClass().getComponentType();
            Object[] out = (Object[])java.lang.reflect.Array.newInstance(componentType, this.myvalues.size());
            Arrays.setAll(out, i -> Array.this.createFieldValue(this.myvalues.get(i)));
            return out;
        }

        @Override
        public boolean add(E o) {
            return this.myvalues.add(this.unwrap(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.myvalues.remove(this.unwrap(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.myvalues.contains(this.unwrap(o))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean result = false;
            for (E o : c) {
                result |= this.myvalues.add(this.unwrap(o));
            }
            return result;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            for (E o : c) {
                this.myvalues.add(index++, this.unwrap(o));
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = false;
            for (Object o : c) {
                result |= this.myvalues.remove(this.unwrap(o));
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("retainAll() not implemented for this type");
        }

        @Override
        public void clear() {
            this.myvalues.clear();
        }

        @Override
        public E get(int index) {
            Object o = this.myvalues.get(index);
            return (E)(o == null ? null : Array.this.createFieldValue(o));
        }

        @Override
        public E set(int index, E element) {
            Object o = this.myvalues.set(index, this.unwrap(element));
            return (E)(o == null ? null : Array.this.createFieldValue(o));
        }

        @Override
        public void add(int index, E element) {
            this.myvalues.add(index, this.unwrap(element));
        }

        @Override
        public E remove(int index) {
            Object o = this.myvalues.remove(index);
            return (E)(o == null ? null : Array.this.createFieldValue(o));
        }

        @Override
        public int indexOf(Object o) {
            return this.myvalues.indexOf(this.unwrap(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.myvalues.lastIndexOf(this.unwrap(o));
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                ListIterator it;
                {
                    this.it = ListWrapper.this.myvalues.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public E next() {
                    return Array.this.createFieldValue(this.it.next());
                }

                @Override
                public boolean hasPrevious() {
                    return this.it.hasPrevious();
                }

                @Override
                public E previous() {
                    return Array.this.createFieldValue(this.it.previous());
                }

                @Override
                public int nextIndex() {
                    return this.it.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.it.previousIndex();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }

                @Override
                public void set(E o) {
                    this.it.set(ListWrapper.this.unwrap(o));
                }

                @Override
                public void add(E o) {
                    this.it.add(ListWrapper.this.unwrap(o));
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new ListWrapper<E>(this.myvalues.subList(fromIndex, toIndex));
        }

        public String toString() {
            return this.myvalues.toString();
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof ListWrapper && this.myvalues.equals(((ListWrapper)o).myvalues);
        }

        @Override
        public int hashCode() {
            return this.myvalues.hashCode();
        }
    }
}

