/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.serialization;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.serialization.DeserializationException;
import com.yahoo.document.serialization.VespaDocumentDeserializer6;
import com.yahoo.document.update.TensorAddUpdate;
import com.yahoo.document.update.TensorModifyUpdate;
import com.yahoo.document.update.TensorRemoveUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.TensorType;

public class VespaDocumentDeserializerHead
extends VespaDocumentDeserializer6 {
    public VespaDocumentDeserializerHead(DocumentTypeManager manager, GrowableByteBuffer buffer) {
        super(manager, buffer);
    }

    @Override
    protected ValueUpdate readTensorModifyUpdate(DataType type) {
        byte operationId = this.getByte(null);
        TensorModifyUpdate.Operation operation = this.decodeOperation(operationId);
        if (operation == null) {
            throw new DeserializationException("Unknown operation id " + operationId + " for tensor modify update");
        }
        if (!(type instanceof TensorDataType)) {
            throw new DeserializationException("Expected tensor data type, got " + String.valueOf(type));
        }
        boolean createNonExistingCells = this.decodeCreateNonExistingCells(operationId);
        if (createNonExistingCells) {
            this.getDouble(null);
        }
        TensorDataType tensorDataType = (TensorDataType)type;
        TensorType tensorType = tensorDataType.getTensorType();
        TensorType convertedType = TensorModifyUpdate.convertDimensionsToMapped(tensorType);
        TensorFieldValue tensor = new TensorFieldValue(convertedType);
        tensor.deserialize(this);
        return new TensorModifyUpdate(operation, tensor, createNonExistingCells);
    }

    private TensorModifyUpdate.Operation decodeOperation(byte operationId) {
        int OP_MASK = 127;
        return TensorModifyUpdate.Operation.getOperation(operationId & OP_MASK);
    }

    private boolean decodeCreateNonExistingCells(byte operationId) {
        int CREATE_FLAG = -128;
        return (operationId & CREATE_FLAG) != 0;
    }

    @Override
    protected ValueUpdate readTensorAddUpdate(DataType type) {
        if (!(type instanceof TensorDataType)) {
            throw new DeserializationException("Expected tensor data type, got " + String.valueOf(type));
        }
        TensorDataType tensorDataType = (TensorDataType)type;
        TensorType tensorType = tensorDataType.getTensorType();
        TensorFieldValue tensor = new TensorFieldValue(tensorType);
        tensor.deserialize(this);
        return new TensorAddUpdate(tensor);
    }

    @Override
    protected ValueUpdate readTensorRemoveUpdate(DataType type) {
        if (!(type instanceof TensorDataType)) {
            throw new DeserializationException("Expected tensor data type, got " + String.valueOf(type));
        }
        TensorDataType tensorDataType = (TensorDataType)type;
        TensorType tensorType = tensorDataType.getTensorType();
        TensorFieldValue tensor = new TensorFieldValue();
        tensor.deserialize(this);
        TensorRemoveUpdate result = new TensorRemoveUpdate(tensor);
        result.verifyCompatibleType(tensorType);
        return result;
    }
}

