/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.StructDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.geo.DegreesParser;
import com.yahoo.yolean.Exceptions;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class PositionDataType {
    public static final StructDataType INSTANCE = PositionDataType.newInstance();
    public static final String STRUCT_NAME = "position";
    public static final String FIELD_X = "x";
    public static final String FIELD_Y = "y";
    private static final Field FFIELD_X = INSTANCE.getField("x");
    private static final Field FFIELD_Y = INSTANCE.getField("y");
    private static final DecimalFormat degreeFmt = new DecimalFormat("0.0#####", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    static String fmtD(double degrees) {
        return degreeFmt.format(degrees);
    }

    private PositionDataType() {
    }

    public static String renderAsString(Struct pos) {
        StringBuilder buf = new StringBuilder();
        double ns = (double)PositionDataType.getYValue(pos).getInteger() / 1000000.0;
        double ew = (double)PositionDataType.getXValue(pos).getInteger() / 1000000.0;
        buf.append(ns < 0.0 ? "S" : "N");
        buf.append(PositionDataType.fmtD(ns < 0.0 ? -ns : ns));
        buf.append(";");
        buf.append(ew < 0.0 ? "W" : "E");
        buf.append(PositionDataType.fmtD(ew < 0.0 ? -ew : ew));
        return buf.toString();
    }

    @Deprecated
    public static void renderXml(Struct pos, XmlStream target) {
        target.addContent(PositionDataType.renderAsString(pos));
    }

    public static Struct valueOf(Integer x, Integer y) {
        Struct ret = new Struct((DataType)INSTANCE);
        ret.setFieldValue(FIELD_X, (FieldValue)(x != null ? new IntegerFieldValue(x) : null));
        ret.setFieldValue(FIELD_Y, (FieldValue)(y != null ? new IntegerFieldValue(y) : null));
        return ret;
    }

    public static Struct fromLong(long val) {
        return PositionDataType.valueOf((int)(val >> 32), (int)val);
    }

    public static Struct fromString(String str) {
        try {
            DegreesParser d = new DegreesParser(str);
            return PositionDataType.valueOf((int)(d.longitude * 1000000.0), (int)(d.latitude * 1000000.0));
        }
        catch (IllegalArgumentException e) {
            try {
                String[] arr = str.split(";");
                if (arr.length == 2) {
                    int x = Integer.parseInt(arr[0]);
                    int y = Integer.parseInt(arr[1]);
                    return PositionDataType.valueOf(x, y);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new IllegalArgumentException("Could not parse '" + str + "' as geo coordinates: " + Exceptions.toMessageString((Throwable)e));
        }
    }

    public static IntegerFieldValue getXValue(FieldValue pos) {
        return Struct.getFieldValue(pos, (DataType)INSTANCE, FFIELD_X, IntegerFieldValue.class);
    }

    public static IntegerFieldValue getYValue(FieldValue pos) {
        return Struct.getFieldValue(pos, (DataType)INSTANCE, FFIELD_Y, IntegerFieldValue.class);
    }

    public static String getZCurveFieldName(String fieldName) {
        return fieldName + "_zcurve";
    }

    private static StructDataType newInstance() {
        StructDataType ret = new StructDataType(STRUCT_NAME);
        ret.addField(new Field(FIELD_X, DataType.INT));
        ret.addField(new Field(FIELD_Y, DataType.INT));
        return ret;
    }

    static {
        degreeFmt.setMinimumIntegerDigits(1);
        degreeFmt.setMinimumFractionDigits(1);
        degreeFmt.setMaximumFractionDigits(6);
    }
}

