/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.DataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;

public class TensorModifyUpdate
extends ValueUpdate<TensorFieldValue> {
    protected Operation operation;
    protected TensorFieldValue tensor;
    protected boolean createNonExistingCells;

    public TensorModifyUpdate(Operation operation, TensorFieldValue tensor) {
        this(operation, tensor, false);
    }

    public TensorModifyUpdate(Operation operation, TensorFieldValue tensor, boolean createNonExistingCells) {
        super(ValueUpdate.ValueUpdateClassID.TENSORMODIFY);
        this.operation = operation;
        this.tensor = tensor;
        this.createNonExistingCells = createNonExistingCells;
        this.verifyCompatibleType(tensor.getDataType().getTensorType());
    }

    private void verifyCompatibleType(TensorType type) {
        if (type.dimensions().stream().anyMatch(dim -> dim.isIndexed())) {
            throw new IllegalArgumentException("Tensor type '" + type + "' is not compatible as it has no mapped dimensions");
        }
    }

    public static TensorType convertDimensionsToMapped(TensorType type) {
        TensorType.Builder builder = new TensorType.Builder(type.valueType());
        type.dimensions().stream().forEach(dim -> builder.mapped(dim.name()));
        return builder.build();
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public TensorFieldValue getValue() {
        return this.tensor;
    }

    public boolean getCreateNonExistingCells() {
        return this.createNonExistingCells;
    }

    public double getDefaultCellValue() {
        return this.operation == Operation.MULTIPLY ? 1.0 : 0.0;
    }

    @Override
    public void setValue(TensorFieldValue value) {
        this.tensor = value;
    }

    @Override
    public FieldValue applyTo(FieldValue oldValue) {
        if (oldValue instanceof TensorFieldValue) {
            Tensor oldTensor = ((TensorFieldValue)oldValue).getTensor().orElseThrow(() -> new IllegalArgumentException("No existing tensor to apply update on"));
            if (this.tensor.getTensor().isPresent()) {
                HashSet<TensorAddress> subspaces;
                DoubleBinaryOperator modifier = switch (this.operation) {
                    case Operation.REPLACE -> (left, right) -> right;
                    case Operation.ADD -> (left, right) -> left + right;
                    case Operation.MULTIPLY -> (left, right) -> left * right;
                    default -> throw new UnsupportedOperationException("Unknown operation: " + this.operation);
                };
                if (this.createNonExistingCells && TensorModifyUpdate.hasMappedSubtype(oldTensor.type()) && !(subspaces = TensorModifyUpdate.findSubspacesNotInInput(oldTensor, this.tensor.getTensor().get())).isEmpty()) {
                    oldTensor = TensorModifyUpdate.insertSubspaces(oldTensor, subspaces, this.getDefaultCellValue());
                }
                Tensor modified = oldTensor.modify(modifier, this.tensor.getTensor().get().cells());
                return new TensorFieldValue(modified);
            }
        } else {
            throw new IllegalStateException("Cannot use tensor modify update on non-tensor datatype " + oldValue.getClass().getName());
        }
        return oldValue;
    }

    private static boolean hasMappedSubtype(TensorType type) {
        return !type.mappedSubtype().equals((Object)TensorType.empty);
    }

    private static boolean hasIndexedSubtype(TensorType type) {
        return !type.indexedSubtype().equals((Object)TensorType.empty);
    }

    private static HashSet<TensorAddress> findSubspacesNotInInput(Tensor input, Tensor modifier) {
        HashSet<TensorAddress> subspaces = new HashSet<TensorAddress>();
        Map inputCells = input.cells();
        TensorType type = input.type();
        Iterator itr = modifier.cellIterator();
        while (itr.hasNext()) {
            Tensor.Cell cell = (Tensor.Cell)itr.next();
            TensorAddress address = cell.getKey();
            if (inputCells.containsKey(address)) continue;
            subspaces.add(TensorModifyUpdate.createSparsePartAddress(address, type));
        }
        return subspaces;
    }

    private static TensorAddress createSparsePartAddress(TensorAddress address, TensorType type) {
        TensorAddress.Builder builder = new TensorAddress.Builder(type.mappedSubtype());
        for (int i = 0; i < type.dimensions().size(); ++i) {
            TensorType.Dimension dim = (TensorType.Dimension)type.dimensions().get(i);
            if (!dim.isMapped()) continue;
            builder.add(dim.name(), address.numericLabel(i));
        }
        return builder.build();
    }

    private static Tensor insertSubspaces(Tensor input, HashSet<TensorAddress> subspaces, double defaultCellValue) {
        Object builder;
        boolean mixed;
        TensorType type = input.type();
        boolean bl = mixed = TensorModifyUpdate.hasMappedSubtype(type) && TensorModifyUpdate.hasIndexedSubtype(type);
        if (mixed) {
            MixedTensor.BoundBuilder boundBuilder = MixedTensor.BoundBuilder.of((TensorType)type);
            double[] values = new double[(int)boundBuilder.denseSubspaceSize()];
            Arrays.fill(values, defaultCellValue);
            for (TensorAddress subspace : subspaces) {
                boundBuilder.block(subspace, values);
            }
            builder = boundBuilder;
        } else {
            builder = Tensor.Builder.of((TensorType)type);
            for (TensorAddress subspace : subspaces) {
                builder.cell(subspace, defaultCellValue);
            }
        }
        Iterator itr = input.cellIterator();
        while (itr.hasNext()) {
            builder.cell((Tensor.Cell)itr.next());
        }
        return builder.build();
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (!(fieldType instanceof TensorDataType)) {
            throw new UnsupportedOperationException("Expected tensor type, got " + fieldType.getName() + ".");
        }
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TensorModifyUpdate that = (TensorModifyUpdate)o;
        return this.operation == that.operation && this.tensor.equals(that.tensor) && this.createNonExistingCells == that.createNonExistingCells;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.operation, this.tensor, this.createNonExistingCells});
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.operation.name + " " + this.tensor + " " + this.createNonExistingCells;
    }

    public static enum Operation {
        REPLACE(0, "replace"),
        ADD(1, "add"),
        MULTIPLY(2, "multiply");

        public final int id;
        public final String name;

        private Operation(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Operation getOperation(int id) {
            for (Operation operation : Operation.values()) {
                if (operation.id != id) continue;
                return operation;
            }
            return null;
        }
    }
}

