/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;

public final class DoubleFieldValue
extends NumericFieldValue {
    public static final int classId = DoubleFieldValue.registerClass((int)4110, DoubleFieldValue.class);
    private double value;

    public static PrimitiveDataType.Factory getFactory() {
        return new Factory();
    }

    public DoubleFieldValue() {
        this(0.0);
    }

    public DoubleFieldValue(double value) {
        this.value = value;
    }

    public DoubleFieldValue(Double value) {
        this.value = value;
    }

    public DoubleFieldValue(String s) {
        this.value = Double.parseDouble(s);
    }

    @Override
    public DoubleFieldValue clone() {
        DoubleFieldValue val = (DoubleFieldValue)super.clone();
        val.value = this.value;
        return val;
    }

    @Override
    public void clear() {
        this.value = 0.0;
    }

    @Override
    public Number getNumber() {
        return this.value;
    }

    @Override
    public void assign(Object obj) {
        if (!this.checkAssign(obj)) {
            return;
        }
        if (obj instanceof Number) {
            this.value = ((Number)obj).doubleValue();
        } else if (obj instanceof NumericFieldValue) {
            this.value = ((NumericFieldValue)obj).getNumber().doubleValue();
        } else if (obj instanceof String || obj instanceof StringFieldValue) {
            this.value = Double.parseDouble(obj.toString());
        } else {
            throw new IllegalArgumentException("Class " + obj.getClass() + " not applicable to an " + this.getClass() + " instance.");
        }
    }

    public double getDouble() {
        return this.value;
    }

    @Override
    public Object getWrappedValue() {
        return this.value;
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    @Override
    @Deprecated
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printDoubleXml(this, xml);
    }

    public String toString() {
        return "" + this.value;
    }

    public int hashCode() {
        int result = super.hashCode();
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleFieldValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DoubleFieldValue that = (DoubleFieldValue)o;
        return Double.compare(that.value, this.value) == 0;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        DoubleFieldValue otherValue = (DoubleFieldValue)fieldValue;
        return Double.compare(this.value, otherValue.value);
    }

    private static class Factory
    extends PrimitiveDataType.Factory {
        private Factory() {
        }

        @Override
        public FieldValue create() {
            return new DoubleFieldValue();
        }

        @Override
        public FieldValue create(String value) {
            return new DoubleFieldValue(value);
        }
    }
}

