/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select.convert;

import com.yahoo.document.select.NowCheckVisitor;
import com.yahoo.document.select.Visitor;
import com.yahoo.document.select.convert.NowQueryExpression;
import com.yahoo.document.select.rule.ArithmeticNode;
import com.yahoo.document.select.rule.AttributeNode;
import com.yahoo.document.select.rule.ComparisonNode;
import com.yahoo.document.select.rule.DocumentNode;
import com.yahoo.document.select.rule.DocumentTypeNode;
import com.yahoo.document.select.rule.EmbracedNode;
import com.yahoo.document.select.rule.ExpressionNode;
import com.yahoo.document.select.rule.IdNode;
import com.yahoo.document.select.rule.LiteralNode;
import com.yahoo.document.select.rule.LogicNode;
import com.yahoo.document.select.rule.NegationNode;
import com.yahoo.document.select.rule.NowNode;
import com.yahoo.document.select.rule.VariableNode;
import java.util.HashMap;
import java.util.Map;

public class SelectionExpressionConverter
implements Visitor {
    private final Map<String, NowQueryExpression> expressionMap = new HashMap<String, NowQueryExpression>();
    private BuildState state = null;

    private boolean hasNow(ExpressionNode node) {
        NowCheckVisitor visitor = new NowCheckVisitor();
        node.accept(visitor);
        return visitor.requiresConversion();
    }

    public Map<String, String> getQueryMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (NowQueryExpression expression : this.expressionMap.values()) {
            ret.put(expression.getDocumentType(), expression.toString());
        }
        return ret;
    }

    @Override
    public void visit(ArithmeticNode node) {
        if (this.state == null) {
            return;
        }
        if (node.getItems().size() > 2) {
            throw new IllegalArgumentException("Too many arithmetic operations");
        }
        for (ArithmeticNode.NodeItem item : node.getItems()) {
            if (item.getOperator() == 2 || item.getOperator() == 0) continue;
            throw new IllegalArgumentException("Arithmetic operator '" + node.operatorToString(item.getOperator()) + "' is not supported");
        }
        this.state.arithmetic = node;
    }

    @Override
    public void visit(AttributeNode node) {
        if (this.state == null) {
            return;
        }
        if (this.expressionMap.containsKey(node.getValue().toString())) {
            throw new IllegalArgumentException("Specifying multiple document types is not allowed");
        }
        for (AttributeNode.Item item : node.getItems()) {
            if (item.getType() == 0) continue;
            throw new IllegalArgumentException("Only attribute items are supported");
        }
        this.state.attribute = node;
    }

    @Override
    public void visit(ComparisonNode node) {
        if (this.state != null) {
            throw new IllegalArgumentException("Comparison cannot be done within now expression");
        }
        if (!this.hasNow(node)) {
            return;
        }
        this.state = new BuildState();
        node.getLHS().accept(this);
        node.getRHS().accept(this);
        if (!">".equals(node.getOperator())) {
            throw new IllegalArgumentException("Comparison operator '" + node.getOperator() + "' is not supported");
        }
        if (!(node.getLHS() instanceof AttributeNode)) {
            throw new IllegalArgumentException("Left hand side of comparison must be a document field");
        }
        this.state.comparison = node;
        if (this.state.attribute != null && (this.state.arithmetic != null || this.state.now != null)) {
            NowQueryExpression expression = new NowQueryExpression(this.state.attribute, this.state.comparison, this.state.arithmetic);
            this.expressionMap.put(expression.getDocumentType(), expression);
            this.state = null;
        }
    }

    @Override
    public void visit(DocumentNode node) {
    }

    @Override
    public void visit(DocumentTypeNode node) {
    }

    @Override
    public void visit(EmbracedNode node) {
        if (this.state == null) {
            return;
        }
        throw new UnsupportedOperationException("Grouping is not supported yet.");
    }

    @Override
    public void visit(IdNode node) {
        if (this.state == null) {
            return;
        }
        throw new UnsupportedOperationException("Document id not supported yet.");
    }

    @Override
    public void visit(LiteralNode node) {
        if (this.state == null) {
            return;
        }
        if (!(node.getValue() instanceof Long)) {
            throw new IllegalArgumentException("Literal " + node + " is not supported");
        }
    }

    @Override
    public void visit(LogicNode node) {
        if (this.state != null) {
            throw new IllegalArgumentException("Logic expressions not supported in now expressions");
        }
        for (LogicNode.NodeItem item : node.getItems()) {
            item.getNode().accept(this);
        }
    }

    @Override
    public void visit(NegationNode node) {
        if (this.state == null) {
            return;
        }
        throw new UnsupportedOperationException("Negation not supported yet.");
    }

    @Override
    public void visit(NowNode node) {
        if (this.state == null) {
            return;
        }
        this.state.now = node;
    }

    @Override
    public void visit(VariableNode node) {
        if (this.state == null) {
            return;
        }
        throw new UnsupportedOperationException("Variables not supported yet.");
    }

    private static class BuildState {
        public AttributeNode attribute;
        public ComparisonNode comparison;
        public ArithmeticNode arithmetic;
        public NowNode now;

        private BuildState() {
        }
    }
}

