/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.SingleValueReader;
import com.yahoo.document.update.ValueUpdate;

public class MapReader {
    public static final String MAP_KEY = "key";
    public static final String MAP_VALUE = "value";
    public static final String UPDATE_ELEMENT = "element";
    public static final String UPDATE_MATCH = "match";

    public static void fillMap(TokenBuffer buffer, MapFieldValue parent, boolean ignoreUndefinedFields) {
        if (buffer.current() == JsonToken.START_ARRAY) {
            MapReader.fillMapFromArray(buffer, parent, ignoreUndefinedFields);
        } else {
            MapReader.fillMapFromObject(buffer, parent, ignoreUndefinedFields);
        }
    }

    public static void fillMapFromArray(TokenBuffer buffer, MapFieldValue parent, boolean ignoreUndefinedFields) {
        JsonToken token = buffer.current();
        int initNesting = buffer.nesting();
        JsonParserHelpers.expectArrayStart(token);
        token = buffer.next();
        DataType keyType = parent.getDataType().getKeyType();
        DataType valueType = parent.getDataType().getValueType();
        while (buffer.nesting() >= initNesting) {
            FieldValue key = null;
            FieldValue value = null;
            JsonParserHelpers.expectObjectStart(token);
            token = buffer.next();
            for (int i = 0; i < 2; ++i) {
                if (MAP_KEY.equals(buffer.currentName())) {
                    key = SingleValueReader.readSingleValue(buffer, keyType, ignoreUndefinedFields);
                } else if (MAP_VALUE.equals(buffer.currentName())) {
                    value = SingleValueReader.readSingleValue(buffer, valueType, ignoreUndefinedFields);
                }
                token = buffer.next();
            }
            Preconditions.checkState((key != null && value != null ? 1 : 0) != 0, (Object)"Missing key or value for map entry.");
            parent.put(key, value);
            JsonParserHelpers.expectObjectEnd(token);
            token = buffer.next();
        }
    }

    public static void fillMapFromObject(TokenBuffer buffer, MapFieldValue parent, boolean ignoreUndefinedFields) {
        JsonToken token = buffer.current();
        int initNesting = buffer.nesting();
        JsonParserHelpers.expectObjectStart(token);
        token = buffer.next();
        DataType keyType = parent.getDataType().getKeyType();
        DataType valueType = parent.getDataType().getValueType();
        while (buffer.nesting() >= initNesting) {
            FieldValue key = SingleValueReader.readAtomic(buffer.currentName(), keyType);
            FieldValue value = SingleValueReader.readSingleValue(buffer, valueType, ignoreUndefinedFields);
            Preconditions.checkState((key != null && value != null ? 1 : 0) != 0, (Object)"Missing key or value for map entry.");
            parent.put(key, value);
            token = buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(token);
    }

    public static ValueUpdate createMapUpdate(TokenBuffer buffer, DataType currentLevel, boolean ignoreUndefinedFields) {
        if (!JsonToken.START_OBJECT.equals((Object)buffer.current())) {
            throw new IllegalArgumentException("Expected object for match update, got " + buffer.current());
        }
        buffer.next();
        FieldValue key = null;
        if (UPDATE_ELEMENT.equals(buffer.currentName())) {
            key = MapReader.keyTypeForMapUpdate(buffer.currentText(), currentLevel);
            buffer.next();
        }
        ValueUpdate update = UPDATE_MATCH.equals(buffer.currentName()) ? MapReader.createMapUpdate(buffer, MapReader.valueTypeForMapUpdate(currentLevel), ignoreUndefinedFields) : SingleValueReader.readSingleUpdate(buffer, MapReader.valueTypeForMapUpdate(currentLevel), buffer.currentName(), ignoreUndefinedFields);
        buffer.next();
        if (key == null) {
            if (!UPDATE_ELEMENT.equals(buffer.currentName())) {
                throw new IllegalArgumentException("Expected match element, got " + buffer.current());
            }
            key = MapReader.keyTypeForMapUpdate(buffer.currentText(), currentLevel);
            buffer.next();
        }
        if (!JsonToken.END_OBJECT.equals((Object)buffer.current())) {
            throw new IllegalArgumentException("Expected object end for match update, got " + buffer.current());
        }
        return ValueUpdate.createMap(key, update);
    }

    public static ValueUpdate createMapUpdate(TokenBuffer buffer, Field field, boolean ignoreUndefinedFields) {
        return MapReader.createMapUpdate(buffer, field.getDataType(), ignoreUndefinedFields);
    }

    private static DataType valueTypeForMapUpdate(DataType parentType) {
        if (parentType instanceof WeightedSetDataType) {
            return DataType.INT;
        }
        if (parentType instanceof CollectionDataType) {
            return ((CollectionDataType)parentType).getNestedType();
        }
        if (parentType instanceof MapDataType) {
            return ((MapDataType)parentType).getValueType();
        }
        throw new UnsupportedOperationException("Unexpected parent type: " + parentType);
    }

    private static FieldValue keyTypeForMapUpdate(String elementText, DataType expectedType) {
        FieldValue v;
        if (expectedType instanceof ArrayDataType) {
            v = new IntegerFieldValue(Integer.valueOf(elementText));
        } else if (expectedType instanceof WeightedSetDataType) {
            v = ((WeightedSetDataType)expectedType).getNestedType().createFieldValue(elementText);
        } else if (expectedType instanceof MapDataType) {
            v = ((MapDataType)expectedType).getKeyType().createFieldValue(elementText);
        } else {
            throw new IllegalArgumentException("Container type " + expectedType + " not supported for match update.");
        }
        return v;
    }
}

