/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.serialization.DocumentSerializer;
import com.yahoo.document.serialization.DocumentSerializerFactory;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.Serializer;

public abstract class FieldValue
extends Identifiable
implements Comparable<FieldValue> {
    public static final int classId = FieldValue.registerClass((int)4105, FieldValue.class);

    public abstract DataType getDataType();

    public static FieldValue create(FieldReader reader, DataType type) {
        FieldValue value = type.createFieldValue();
        value.deserialize(reader);
        return value;
    }

    @Deprecated
    public String toXml() {
        XmlStream xml = new XmlStream();
        xml.setIndent("  ");
        xml.beginTag("value");
        this.printXml(xml);
        xml.endTag();
        return xml.toString();
    }

    public final void deserialize(FieldReader reader) {
        this.deserialize(null, reader);
    }

    public final void serialize(GrowableByteBuffer buf) {
        this.serialize(DocumentSerializerFactory.create6(buf));
    }

    @Deprecated
    public abstract void printXml(XmlStream var1);

    public abstract void clear();

    public FieldValue clone() {
        return (FieldValue)super.clone();
    }

    boolean checkAssign(Object o) {
        if (o == null) {
            this.clear();
            return false;
        }
        return true;
    }

    public abstract void assign(Object var1);

    public Object getWrappedValue() {
        return this;
    }

    public FieldValue getRecursiveValue(String path) {
        return this.getRecursiveValue(this.getDataType().buildFieldPath(path));
    }

    public FieldValue getRecursiveValue(FieldPath path) {
        RecursiveIteratorHandler handler = new RecursiveIteratorHandler();
        this.iterateNested(path, 0, handler);
        return handler.retVal;
    }

    public void onSerialize(Serializer target) {
        if (target instanceof FieldWriter) {
            this.serialize(null, (FieldWriter)target);
        } else if (target instanceof BufferSerializer) {
            this.serialize(null, DocumentSerializerFactory.create6(((BufferSerializer)target).getBuf()));
        } else {
            DocumentSerializer fw = DocumentSerializerFactory.create6(new GrowableByteBuffer());
            this.serialize(null, fw);
            target.put(null, fw.getBuf().getByteBuffer());
        }
    }

    public void onDeserialize(Deserializer data) {
        if (!(data instanceof FieldReader)) {
            throw new IllegalArgumentException("I am not able to deserialize from " + data.getClass().getName());
        }
        this.deserialize(null, (FieldReader)data);
    }

    FieldPathIteratorHandler.ModificationStatus iterateNested(FieldPath fieldPath, int pos, FieldPathIteratorHandler handler) {
        if (pos >= fieldPath.size()) {
            handler.onPrimitive(this);
            return handler.modify(this);
        }
        throw new IllegalArgumentException("Primitive types can't be iterated through");
    }

    public abstract void serialize(Field var1, FieldWriter var2);

    public abstract void deserialize(Field var1, FieldReader var2);

    @Override
    public int compareTo(FieldValue fieldValue) {
        return this.getDataType().compareTo(fieldValue.getDataType());
    }

    static class RecursiveIteratorHandler
    extends FieldPathIteratorHandler {
        FieldValue retVal = null;
        boolean multiValue = false;

        RecursiveIteratorHandler() {
        }

        @Override
        public boolean onComplex(FieldValue fv) {
            this.onPrimitive(fv);
            return false;
        }

        @Override
        public void onPrimitive(FieldValue fv) {
            if (this.retVal != null) {
                if (this.multiValue) {
                    ((Array)this.retVal).add(fv);
                } else {
                    Array<FieldValue> afv = new Array<FieldValue>((DataType)new ArrayDataType(this.retVal.getDataType()));
                    afv.add(this.retVal);
                    afv.add(fv);
                    this.retVal = afv;
                    this.multiValue = true;
                }
            } else {
                this.retVal = fv;
            }
        }
    }
}

