/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.FieldPath;
import com.yahoo.document.annotation.AnnotationReference;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.ReferenceFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.fieldpathupdate.AddFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.AssignFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.fieldpathupdate.RemoveFieldPathUpdate;
import com.yahoo.document.json.JsonSerializationHelper;
import com.yahoo.document.json.readers.SingleValueReader;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.update.AddValueUpdate;
import com.yahoo.document.update.ArithmeticValueUpdate;
import com.yahoo.document.update.AssignValueUpdate;
import com.yahoo.document.update.ClearValueUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.RemoveValueUpdate;
import com.yahoo.document.update.TensorAddUpdate;
import com.yahoo.document.update.TensorModifyUpdate;
import com.yahoo.document.update.TensorRemoveUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.vespa.objects.FieldBase;
import com.yahoo.vespa.objects.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class DocumentUpdateJsonSerializer {
    private static final JsonFactory jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build())).build();
    private final JsonDocumentUpdateWriter writer = new JsonDocumentUpdateWriter();
    private JsonGenerator generator;

    public DocumentUpdateJsonSerializer(OutputStream outputStream) {
        JsonSerializationHelper.wrapIOException(() -> {
            this.generator = jsonFactory.createGenerator(outputStream);
        });
    }

    public DocumentUpdateJsonSerializer(JsonGenerator generator) {
        this.generator = generator;
    }

    public void serialize(DocumentUpdate update) {
        this.writer.write(update);
    }

    private class JsonDocumentUpdateWriter
    implements DocumentUpdateWriter,
    FieldWriter {
        private JsonDocumentUpdateWriter() {
        }

        @Override
        public void write(DocumentUpdate update) {
            JsonSerializationHelper.wrapIOException(() -> {
                Optional<Boolean> createIfNotExistent;
                DocumentUpdateJsonSerializer.this.generator.writeStartObject();
                DocumentUpdateJsonSerializer.this.generator.writeStringField("update", update.getId().toString());
                if (update.getCondition().isPresent()) {
                    DocumentUpdateJsonSerializer.this.generator.writeStringField("condition", update.getCondition().getSelection());
                }
                if ((createIfNotExistent = update.getOptionalCreateIfNonExistent()).isPresent() && createIfNotExistent.get().booleanValue()) {
                    DocumentUpdateJsonSerializer.this.generator.writeBooleanField("create", createIfNotExistent.get().booleanValue());
                }
                DocumentUpdateJsonSerializer.this.generator.writeObjectFieldStart("fields");
                for (FieldUpdate up : update.fieldUpdates()) {
                    up.serialize(this);
                }
                update.fieldPathUpdates().stream().collect(Collectors.groupingBy(FieldPathUpdate::getFieldPath)).forEach((fieldPath, fieldPathUpdates) -> JsonSerializationHelper.wrapIOException(() -> this.write((FieldPath)fieldPath, (Collection<FieldPathUpdate>)fieldPathUpdates, DocumentUpdateJsonSerializer.this.generator)));
                DocumentUpdateJsonSerializer.this.generator.writeEndObject();
                DocumentUpdateJsonSerializer.this.generator.writeEndObject();
                DocumentUpdateJsonSerializer.this.generator.flush();
            });
        }

        private void write(FieldPath fieldPath, Collection<FieldPathUpdate> fieldPathUpdates, JsonGenerator generator) throws IOException {
            generator.writeObjectFieldStart(fieldPath.toString());
            for (FieldPathUpdate update : fieldPathUpdates) {
                if (this.writeArithmeticFieldPathUpdate(update, generator)) continue;
                generator.writeFieldName(update.getUpdateType().name().toLowerCase());
                if (update instanceof AssignFieldPathUpdate) {
                    AssignFieldPathUpdate assignUp = (AssignFieldPathUpdate)update;
                    if (assignUp.getExpression() != null) {
                        throw new RuntimeException("Unable to parse expression: " + assignUp.getExpression());
                    }
                    assignUp.getNewValue().serialize(null, this);
                    continue;
                }
                if (update instanceof AddFieldPathUpdate) {
                    ((AddFieldPathUpdate)update).getNewValues().serialize(null, this);
                    continue;
                }
                if (update instanceof RemoveFieldPathUpdate) {
                    generator.writeNumber(0);
                    continue;
                }
                throw new RuntimeException("Unsupported fieldpath operation: " + update.getClass().getName());
            }
            generator.writeEndObject();
        }

        private boolean writeArithmeticFieldPathUpdate(FieldPathUpdate fieldPathUpdate, JsonGenerator generator) throws IOException {
            if (!(fieldPathUpdate instanceof AssignFieldPathUpdate)) {
                return false;
            }
            String expression = ((AssignFieldPathUpdate)fieldPathUpdate).getExpression();
            if (expression == null) {
                return false;
            }
            Matcher matcher = SingleValueReader.matchArithmeticOperation(expression);
            if (matcher.find()) {
                String updateOperation = SingleValueReader.ARITHMETIC_SIGN_TO_UPDATE_OPERATION.get(matcher.group(1));
                double value = Double.valueOf(matcher.group(2));
                generator.writeNumberField(updateOperation, value);
                return true;
            }
            return false;
        }

        @Override
        public void write(FieldUpdate fieldUpdate) {
            JsonSerializationHelper.wrapIOException(() -> {
                DocumentUpdateJsonSerializer.this.generator.writeObjectFieldStart(fieldUpdate.getField().getName());
                ArrayList<ValueUpdate> removeValueUpdates = new ArrayList<ValueUpdate>();
                ArrayList<ValueUpdate> addValueUpdates = new ArrayList<ValueUpdate>();
                DataType dataType = fieldUpdate.getField().getDataType();
                for (ValueUpdate valueUpdate : fieldUpdate.getValueUpdates()) {
                    if (valueUpdate instanceof RemoveValueUpdate) {
                        removeValueUpdates.add(valueUpdate);
                        continue;
                    }
                    if (valueUpdate instanceof AddValueUpdate) {
                        addValueUpdates.add(valueUpdate);
                        continue;
                    }
                    valueUpdate.serialize(this, dataType);
                }
                this.writeAddOrRemoveValueUpdates("remove", removeValueUpdates, dataType);
                this.writeAddOrRemoveValueUpdates("add", addValueUpdates, dataType);
                DocumentUpdateJsonSerializer.this.generator.writeEndObject();
            });
        }

        private void writeAddOrRemoveValueUpdates(String arrayFieldName, ArrayList<ValueUpdate> valueUpdates, DataType dataType) throws IOException {
            if (!valueUpdates.isEmpty()) {
                DocumentUpdateJsonSerializer.this.generator.writeArrayFieldStart(arrayFieldName);
                for (ValueUpdate valueUpdate : valueUpdates) {
                    valueUpdate.serialize(this, dataType);
                }
                DocumentUpdateJsonSerializer.this.generator.writeEndArray();
            }
        }

        @Override
        public void write(AddValueUpdate update, DataType superType) {
            update.getValue().serialize(this);
        }

        @Override
        public void write(MapValueUpdate update, DataType superType) {
            JsonSerializationHelper.wrapIOException(() -> {
                DocumentUpdateJsonSerializer.this.generator.writeObjectFieldStart("match");
                DocumentUpdateJsonSerializer.this.generator.writeFieldName("element");
                update.getValue().serialize(null, this);
                update.getUpdate().serialize(this, superType);
                DocumentUpdateJsonSerializer.this.generator.writeEndObject();
            });
        }

        @Override
        public void write(ArithmeticValueUpdate update) {
            ArithmeticValueUpdate.Operator operator = update.getOperator();
            JsonSerializationHelper.wrapIOException(() -> this.lambda$write$5(switch (operator) {
                case ArithmeticValueUpdate.Operator.ADD -> "increment";
                case ArithmeticValueUpdate.Operator.DIV -> "divide";
                case ArithmeticValueUpdate.Operator.MUL -> "multiply";
                case ArithmeticValueUpdate.Operator.SUB -> "decrement";
                default -> throw new RuntimeException("Unrecognized arithmetic operator '%s'".formatted(operator.name));
            }));
            update.getValue().serialize(this);
        }

        @Override
        public void write(AssignValueUpdate update, DataType superType) {
            JsonSerializationHelper.wrapIOException(() -> DocumentUpdateJsonSerializer.this.generator.writeFieldName("assign"));
            update.getValue().serialize(null, this);
        }

        @Override
        public void write(RemoveValueUpdate update, DataType superType) {
            update.getValue().serialize(null, this);
        }

        @Override
        public void write(ClearValueUpdate clearValueUpdate, DataType superType) {
            JsonSerializationHelper.wrapIOException(() -> DocumentUpdateJsonSerializer.this.generator.writeNullField("assign"));
        }

        @Override
        public void write(TensorModifyUpdate update) {
            JsonSerializationHelper.wrapIOException(() -> {
                DocumentUpdateJsonSerializer.this.generator.writeObjectFieldStart("modify");
                DocumentUpdateJsonSerializer.this.generator.writeFieldName("operation");
                DocumentUpdateJsonSerializer.this.generator.writeString(update.getOperation().name);
                if (update.getValue().getTensor().isPresent()) {
                    JsonSerializationHelper.serializeTensorCells(DocumentUpdateJsonSerializer.this.generator, update.getValue().getTensor().get());
                }
                DocumentUpdateJsonSerializer.this.generator.writeEndObject();
            });
        }

        @Override
        public void write(TensorAddUpdate update) {
            JsonSerializationHelper.wrapIOException(() -> {
                DocumentUpdateJsonSerializer.this.generator.writeObjectFieldStart("add");
                if (update.getValue().getTensor().isPresent()) {
                    JsonSerializationHelper.serializeTensorCells(DocumentUpdateJsonSerializer.this.generator, update.getValue().getTensor().get());
                }
                DocumentUpdateJsonSerializer.this.generator.writeEndObject();
            });
        }

        @Override
        public void write(TensorRemoveUpdate update) {
            JsonSerializationHelper.wrapIOException(() -> {
                DocumentUpdateJsonSerializer.this.generator.writeObjectFieldStart("remove");
                if (update.getValue().getTensor().isPresent()) {
                    JsonSerializationHelper.serializeTensorAddresses(DocumentUpdateJsonSerializer.this.generator, update.getValue().getTensor().get());
                }
                DocumentUpdateJsonSerializer.this.generator.writeEndObject();
            });
        }

        @Override
        public void write(FieldBase field, FieldValue value) {
            throw new JsonSerializationHelper.JsonSerializationException(String.format("Serialization of field values of type %s is not supported", value.getClass().getName()));
        }

        @Override
        public void write(FieldBase field, Document value) {
            throw new JsonSerializationHelper.JsonSerializationException("Serialization of 'Document fields' is not supported");
        }

        @Override
        public <T extends FieldValue> void write(FieldBase field, Array<T> array) {
            JsonSerializationHelper.serializeArrayField(this, DocumentUpdateJsonSerializer.this.generator, field, array);
        }

        @Override
        public <K extends FieldValue, V extends FieldValue> void write(FieldBase field, MapFieldValue<K, V> map) {
            JsonSerializationHelper.serializeMapField(this, DocumentUpdateJsonSerializer.this.generator, field, map);
        }

        @Override
        public void write(FieldBase field, ByteFieldValue value) {
            JsonSerializationHelper.serializeByteField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, BoolFieldValue value) {
            JsonSerializationHelper.serializeBoolField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public <T extends FieldValue> void write(FieldBase field, CollectionFieldValue<T> value) {
            JsonSerializationHelper.serializeCollectionField(this, DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, DoubleFieldValue value) {
            JsonSerializationHelper.serializeDoubleField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, FloatFieldValue value) {
            JsonSerializationHelper.serializeFloatField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, IntegerFieldValue value) {
            JsonSerializationHelper.serializeIntField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, LongFieldValue value) {
            JsonSerializationHelper.serializeLongField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, Raw value) {
            JsonSerializationHelper.serializeRawField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, PredicateFieldValue value) {
            JsonSerializationHelper.serializePredicateField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, StringFieldValue value) {
            JsonSerializationHelper.serializeStringField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, TensorFieldValue value) {
            JsonSerializationHelper.serializeTensorField(DocumentUpdateJsonSerializer.this.generator, field, value, false, false);
        }

        @Override
        public void write(FieldBase field, ReferenceFieldValue value) {
            JsonSerializationHelper.serializeReferenceField(DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, Struct value) {
            JsonSerializationHelper.serializeStructField(this, DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public void write(FieldBase field, StructuredFieldValue value) {
            JsonSerializationHelper.serializeStructuredField(this, DocumentUpdateJsonSerializer.this.generator, field, value);
        }

        @Override
        public <T extends FieldValue> void write(FieldBase field, WeightedSet<T> weightedSet) {
            JsonSerializationHelper.serializeWeightedSet(DocumentUpdateJsonSerializer.this.generator, field, weightedSet);
        }

        @Override
        public void write(FieldBase field, AnnotationReference value) {
        }

        public Serializer putByte(FieldBase field, byte value) {
            JsonSerializationHelper.serializeByte(DocumentUpdateJsonSerializer.this.generator, field, value);
            return this;
        }

        public Serializer putShort(FieldBase field, short value) {
            JsonSerializationHelper.serializeShort(DocumentUpdateJsonSerializer.this.generator, field, value);
            return this;
        }

        public Serializer putInt(FieldBase field, int value) {
            JsonSerializationHelper.serializeInt(DocumentUpdateJsonSerializer.this.generator, field, value);
            return this;
        }

        public Serializer putLong(FieldBase field, long value) {
            JsonSerializationHelper.serializeLong(DocumentUpdateJsonSerializer.this.generator, field, value);
            return this;
        }

        public Serializer putFloat(FieldBase field, float value) {
            JsonSerializationHelper.serializeFloat(DocumentUpdateJsonSerializer.this.generator, field, value);
            return this;
        }

        public Serializer putDouble(FieldBase field, double value) {
            JsonSerializationHelper.serializeDouble(DocumentUpdateJsonSerializer.this.generator, field, value);
            return this;
        }

        public Serializer put(FieldBase field, byte[] value) {
            JsonSerializationHelper.serializeByteArray(DocumentUpdateJsonSerializer.this.generator, field, value);
            return this;
        }

        public Serializer put(FieldBase field, ByteBuffer value) {
            JsonSerializationHelper.serializeByteBuffer(DocumentUpdateJsonSerializer.this.generator, field, value);
            return this;
        }

        public Serializer put(FieldBase field, String value) {
            JsonSerializationHelper.serializeString(DocumentUpdateJsonSerializer.this.generator, field, value);
            return this;
        }

        private /* synthetic */ void lambda$write$5(String operationKey) throws IOException {
            DocumentUpdateJsonSerializer.this.generator.writeFieldName(operationKey);
        }
    }
}

