/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.JsonFormat;

public class TensorReader {
    public static final String TENSOR_TYPE = "type";
    public static final String TENSOR_ADDRESS = "address";
    public static final String TENSOR_CELLS = "cells";
    public static final String TENSOR_VALUES = "values";
    public static final String TENSOR_BLOCKS = "blocks";
    public static final String TENSOR_VALUE = "value";

    static void fillTensor(TokenBuffer buffer, TensorFieldValue tensorFieldValue) {
        Tensor.Builder builder = Tensor.Builder.of((TensorType)tensorFieldValue.getDataType().getTensorType());
        JsonParserHelpers.expectOneOf(buffer.current(), JsonToken.START_OBJECT, JsonToken.START_ARRAY);
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            if (TENSOR_CELLS.equals(buffer.currentName()) && !TensorReader.primitiveContent(buffer)) {
                TensorReader.readTensorCells(buffer, builder);
            } else if (TENSOR_VALUES.equals(buffer.currentName()) && builder.type().dimensions().stream().allMatch(d -> d.isIndexed())) {
                TensorReader.readTensorValues(buffer, builder);
            } else if (TENSOR_BLOCKS.equals(buffer.currentName())) {
                TensorReader.readTensorBlocks(buffer, builder);
            } else if (!TENSOR_TYPE.equals(buffer.currentName()) || buffer.current() != JsonToken.VALUE_STRING) {
                buffer.previous();
                TensorReader.readDirectTensorValue(buffer, builder);
                buffer.previous();
            }
            buffer.next();
        }
        JsonParserHelpers.expectOneOf(buffer.current(), JsonToken.END_OBJECT, JsonToken.END_ARRAY);
        tensorFieldValue.assign(builder.build());
    }

    static boolean primitiveContent(TokenBuffer buffer) {
        JsonToken cellsValue = buffer.current();
        if (cellsValue.isScalarValue()) {
            return true;
        }
        if (cellsValue == JsonToken.START_ARRAY) {
            JsonToken firstArrayValue = buffer.peek(1);
            if (firstArrayValue == JsonToken.END_ARRAY) {
                return false;
            }
            if (firstArrayValue.isScalarValue()) {
                return true;
            }
        }
        return false;
    }

    static void readTensorCells(TokenBuffer buffer, Tensor.Builder builder) {
        if (buffer.current() == JsonToken.START_ARRAY) {
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                TensorReader.readTensorCell(buffer, builder);
                buffer.next();
            }
        } else if (buffer.current() == JsonToken.START_OBJECT) {
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                builder.cell(TensorReader.asAddress(buffer.currentName(), builder.type()), TensorReader.readDouble(buffer));
                buffer.next();
            }
        } else {
            throw new IllegalArgumentException("Expected 'cells' to contain an array or an object, but got " + buffer.current());
        }
        JsonParserHelpers.expectCompositeEnd(buffer.current());
    }

    private static void readTensorCell(TokenBuffer buffer, Tensor.Builder builder) {
        JsonParserHelpers.expectObjectStart(buffer.current());
        TensorAddress address = null;
        Double value = null;
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String currentName = buffer.currentName();
            if (TENSOR_ADDRESS.equals(currentName)) {
                address = TensorReader.readAddress(buffer, builder.type());
            } else if (TENSOR_VALUE.equals(currentName)) {
                value = TensorReader.readDouble(buffer);
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.current());
        if (address == null) {
            throw new IllegalArgumentException("Expected an object in a tensor 'cells' array to contain an 'address' field");
        }
        if (value == null) {
            throw new IllegalArgumentException("Expected an object in a tensor 'cells' array to contain a 'value' field");
        }
        builder.cell(address, value.doubleValue());
    }

    private static void readTensorValues(TokenBuffer buffer, Tensor.Builder builder) {
        if (!(builder instanceof IndexedTensor.BoundBuilder)) {
            throw new IllegalArgumentException("The 'values' field can only be used with dense tensors. Use 'cells' or 'blocks' instead");
        }
        IndexedTensor.BoundBuilder indexedBuilder = (IndexedTensor.BoundBuilder)builder;
        if (buffer.current() == JsonToken.VALUE_STRING) {
            double[] decoded = JsonFormat.decodeHexString((String)buffer.currentText(), (TensorType.Value)builder.type().valueType());
            if (decoded.length == 0) {
                throw new IllegalArgumentException("The 'values' string does not contain any values");
            }
            for (int i = 0; i < decoded.length; ++i) {
                indexedBuilder.cellByDirectIndex((long)i, decoded[i]);
            }
            return;
        }
        int index = 0;
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            if (buffer.current() != JsonToken.START_ARRAY && buffer.current() != JsonToken.END_ARRAY) {
                indexedBuilder.cellByDirectIndex((long)index++, TensorReader.readDouble(buffer));
            }
            buffer.next();
        }
        if (index == 0) {
            throw new IllegalArgumentException("The 'values' array does not contain any values");
        }
        JsonParserHelpers.expectCompositeEnd(buffer.current());
    }

    static void readTensorBlocks(TokenBuffer buffer, Tensor.Builder builder) {
        if (!(builder instanceof MixedTensor.BoundBuilder)) {
            throw new IllegalArgumentException("The 'blocks' field can only be used with mixed tensors with bound dimensions. Use 'cells' or 'values' instead");
        }
        MixedTensor.BoundBuilder mixedBuilder = (MixedTensor.BoundBuilder)builder;
        if (buffer.current() == JsonToken.START_ARRAY) {
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                TensorReader.readTensorBlock(buffer, mixedBuilder);
                buffer.next();
            }
        } else if (buffer.current() == JsonToken.START_OBJECT) {
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                TensorAddress mappedAddress = TensorReader.asAddress(buffer.currentName(), builder.type().mappedSubtype());
                mixedBuilder.block(mappedAddress, TensorReader.readValues(buffer, (int)mixedBuilder.denseSubspaceSize(), mappedAddress, mixedBuilder.type()));
                buffer.next();
            }
        } else {
            throw new IllegalArgumentException("Expected 'blocks' to contain an array or an object, but got " + buffer.current());
        }
        JsonParserHelpers.expectCompositeEnd(buffer.current());
    }

    private static void readTensorBlock(TokenBuffer buffer, MixedTensor.BoundBuilder mixedBuilder) {
        JsonParserHelpers.expectObjectStart(buffer.current());
        TensorAddress address = null;
        double[] values = null;
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String currentName = buffer.currentName();
            if (TENSOR_ADDRESS.equals(currentName)) {
                address = TensorReader.readAddress(buffer, mixedBuilder.type().mappedSubtype());
            } else if (TENSOR_VALUES.equals(currentName)) {
                values = TensorReader.readValues(buffer, (int)mixedBuilder.denseSubspaceSize(), address, mixedBuilder.type());
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.current());
        if (address == null) {
            throw new IllegalArgumentException("Expected a 'blocks' array object to contain an object 'address'");
        }
        if (values == null) {
            throw new IllegalArgumentException("Expected a 'blocks' array object to contain an array 'values'");
        }
        mixedBuilder.block(address, values);
    }

    private static void readDirectTensorValue(TokenBuffer buffer, Tensor.Builder builder) {
        boolean hasIndexed = builder.type().dimensions().stream().anyMatch(TensorType.Dimension::isIndexed);
        boolean hasMapped = builder.type().dimensions().stream().anyMatch(TensorType.Dimension::isMapped);
        if (TensorReader.isArrayOfObjects(buffer, 0)) {
            TensorReader.readTensorCells(buffer, builder);
        } else if (!hasMapped) {
            TensorReader.readTensorValues(buffer, builder);
        } else if (hasMapped && hasIndexed) {
            TensorReader.readTensorBlocks(buffer, builder);
        } else {
            TensorReader.readTensorCells(buffer, builder);
        }
    }

    private static boolean isArrayOfObjects(TokenBuffer buffer, int ahead) {
        if (buffer.peek(ahead++) != JsonToken.START_ARRAY) {
            return false;
        }
        if (buffer.peek(ahead) == JsonToken.START_ARRAY) {
            return TensorReader.isArrayOfObjects(buffer, ahead);
        }
        return buffer.peek(ahead) == JsonToken.START_OBJECT;
    }

    private static TensorAddress readAddress(TokenBuffer buffer, TensorType type) {
        JsonParserHelpers.expectObjectStart(buffer.current());
        TensorAddress.Builder builder = new TensorAddress.Builder(type);
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            builder.add(buffer.currentName(), buffer.currentText());
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.current());
        return builder.build();
    }

    private static double[] readValues(TokenBuffer buffer, int size, TensorAddress address, TensorType type) {
        int index = 0;
        double[] values = new double[size];
        if (buffer.current() == JsonToken.VALUE_STRING) {
            values = JsonFormat.decodeHexString((String)buffer.currentText(), (TensorType.Value)type.valueType());
            index = values.length;
        } else {
            JsonParserHelpers.expectArrayStart(buffer.current());
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                if (buffer.current() != JsonToken.START_ARRAY && buffer.current() != JsonToken.END_ARRAY) {
                    values[index++] = TensorReader.readDouble(buffer);
                }
                buffer.next();
            }
            JsonParserHelpers.expectCompositeEnd(buffer.current());
        }
        if (index != size) {
            throw new IllegalArgumentException((String)(address != null ? "At " + address.toString(type) + ": " : "") + "Expected " + size + " values, but got " + index);
        }
        return values;
    }

    private static double readDouble(TokenBuffer buffer) {
        try {
            return Double.parseDouble(buffer.currentText());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected a number but got '" + buffer.currentText() + "'");
        }
    }

    private static TensorAddress asAddress(String label, TensorType type) {
        if (type.dimensions().size() != 1) {
            throw new IllegalArgumentException("Expected a tensor with a single dimension but got '" + type + "'");
        }
        return new TensorAddress.Builder(type).add(((TensorType.Dimension)type.dimensions().get(0)).name(), label).build();
    }
}

